package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaChannelBuilder extends KafkaChannelFluentImpl<KafkaChannelBuilder> implements VisitableBuilder<KafkaChannel,KafkaChannelBuilder> {

    KafkaChannelFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaChannelBuilder() { 
        this(true);
    }


    public KafkaChannelBuilder(Boolean validationEnabled) { 
        this(new KafkaChannel(), validationEnabled);
    }


    public KafkaChannelBuilder(KafkaChannelFluent<?> fluent) { 
        this(fluent, true);
    }


    public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KafkaChannel(), validationEnabled);
    }


    public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,KafkaChannel instance) { 
        this(fluent, instance, true);
    }


    public KafkaChannelBuilder(KafkaChannelFluent<?> fluent,KafkaChannel instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaChannelBuilder(KafkaChannel instance) { 
        this(instance,true);
    }


    public KafkaChannelBuilder(KafkaChannel instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaChannel build() {
        KafkaChannel buildable = new KafkaChannel(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaChannelBuilder that = (KafkaChannelBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
