package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaSourceSpecBuilder extends KafkaSourceSpecFluentImpl<KafkaSourceSpecBuilder> implements VisitableBuilder<KafkaSourceSpec,KafkaSourceSpecBuilder> {

    KafkaSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaSourceSpecBuilder() { 
        this(true);
    }


    public KafkaSourceSpecBuilder(Boolean validationEnabled) { 
        this(new KafkaSourceSpec(), validationEnabled);
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KafkaSourceSpec(), validationEnabled);
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance) { 
        this(fluent, instance, true);
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpecFluent<?> fluent,KafkaSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBootstrapServers(instance.getBootstrapServers()); 
        fluent.withCeOverrides(instance.getCeOverrides()); 
        fluent.withConsumerGroup(instance.getConsumerGroup()); 
        fluent.withNet(instance.getNet()); 
        fluent.withSink(instance.getSink()); 
        fluent.withTopics(instance.getTopics()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpec instance) { 
        this(instance,true);
    }


    public KafkaSourceSpecBuilder(KafkaSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBootstrapServers(instance.getBootstrapServers()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withConsumerGroup(instance.getConsumerGroup()); 
        this.withNet(instance.getNet()); 
        this.withSink(instance.getSink()); 
        this.withTopics(instance.getTopics()); 
        this.validationEnabled = validationEnabled; 
    }


    public KafkaSourceSpec build() {
        KafkaSourceSpec buildable = new KafkaSourceSpec(fluent.getBootstrapServers(),fluent.getCeOverrides(),fluent.getConsumerGroup(),fluent.getNet(),fluent.getSink(),fluent.getTopics());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSourceSpecBuilder that = (KafkaSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
