package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InMemoryChannelSpecBuilder extends InMemoryChannelSpecFluentImpl<InMemoryChannelSpecBuilder> implements VisitableBuilder<InMemoryChannelSpec,InMemoryChannelSpecBuilder> {

    InMemoryChannelSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InMemoryChannelSpecBuilder() { 
        this(true);
    }


    public InMemoryChannelSpecBuilder(Boolean validationEnabled) { 
        this(new InMemoryChannelSpec(), validationEnabled);
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new InMemoryChannelSpec(), validationEnabled);
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance) { 
        this(fluent, instance, true);
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDelivery(instance.getDelivery()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance) { 
        this(instance,true);
    }


    public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDelivery(instance.getDelivery()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public InMemoryChannelSpec build() {
        InMemoryChannelSpec buildable = new InMemoryChannelSpec(fluent.getDelivery(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InMemoryChannelSpecBuilder that = (InMemoryChannelSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
