package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;

public interface SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>> extends Fluent<A> {


    public ObjectReference getChannel();
    public A withChannel(ObjectReference channel);
    public Boolean hasChannel();
    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery();
    public DeliverySpec buildDelivery();
    public A withDelivery(DeliverySpec delivery);
    public Boolean hasDelivery();
    public SubscriptionSpecFluent.DeliveryNested<A> withNewDelivery();
    public SubscriptionSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item);
    public SubscriptionSpecFluent.DeliveryNested<A> editDelivery();
    public SubscriptionSpecFluent.DeliveryNested<A> editOrNewDelivery();
    public SubscriptionSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item);
    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@Deprecated public Destination getReply();
    public Destination buildReply();
    public A withReply(Destination reply);
    public Boolean hasReply();
    public SubscriptionSpecFluent.ReplyNested<A> withNewReply();
    public SubscriptionSpecFluent.ReplyNested<A> withNewReplyLike(Destination item);
    public SubscriptionSpecFluent.ReplyNested<A> editReply();
    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReply();
    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item);
    
/**
 * This method has been deprecated, please use method buildSubscriber instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSubscriber();
    public Destination buildSubscriber();
    public A withSubscriber(Destination subscriber);
    public Boolean hasSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriberLike(Destination item);
    public SubscriptionSpecFluent.SubscriberNested<A> editSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(Destination item);
    public interface DeliveryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeliverySpecFluent<SubscriptionSpecFluent.DeliveryNested<N>> {

        public N and();
        public N endDelivery();    }


    public interface ReplyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<SubscriptionSpecFluent.ReplyNested<N>> {

        public N and();
        public N endReply();    }


    public interface SubscriberNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<SubscriptionSpecFluent.SubscriberNested<N>> {

        public N and();
        public N endSubscriber();    }


}
