package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApiServerSourceStatusBuilder extends ApiServerSourceStatusFluentImpl<ApiServerSourceStatusBuilder> implements VisitableBuilder<ApiServerSourceStatus,ApiServerSourceStatusBuilder> {

    ApiServerSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ApiServerSourceStatusBuilder() { 
        this(true);
    }


    public ApiServerSourceStatusBuilder(Boolean validationEnabled) { 
        this(new ApiServerSourceStatus(), validationEnabled);
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ApiServerSourceStatus(), validationEnabled);
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,ApiServerSourceStatus instance) { 
        this(fluent, instance, true);
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatusFluent<?> fluent,ApiServerSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatus instance) { 
        this(instance,true);
    }


    public ApiServerSourceStatusBuilder(ApiServerSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public ApiServerSourceStatus build() {
        ApiServerSourceStatus buildable = new ApiServerSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ApiServerSourceStatusBuilder that = (ApiServerSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
