package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PingSourceStatusBuilder extends PingSourceStatusFluentImpl<PingSourceStatusBuilder> implements VisitableBuilder<PingSourceStatus,PingSourceStatusBuilder> {

    PingSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PingSourceStatusBuilder() { 
        this(true);
    }


    public PingSourceStatusBuilder(Boolean validationEnabled) { 
        this(new PingSourceStatus(), validationEnabled);
    }


    public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PingSourceStatus(), validationEnabled);
    }


    public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,PingSourceStatus instance) { 
        this(fluent, instance, true);
    }


    public PingSourceStatusBuilder(PingSourceStatusFluent<?> fluent,PingSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public PingSourceStatusBuilder(PingSourceStatus instance) { 
        this(instance,true);
    }


    public PingSourceStatusBuilder(PingSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public PingSourceStatus build() {
        PingSourceStatus buildable = new PingSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PingSourceStatusBuilder that = (PingSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
