package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AwsSqsSourceSpecBuilder extends AwsSqsSourceSpecFluentImpl<AwsSqsSourceSpecBuilder> implements VisitableBuilder<AwsSqsSourceSpec,AwsSqsSourceSpecBuilder> {

    AwsSqsSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AwsSqsSourceSpecBuilder() { 
        this(true);
    }


    public AwsSqsSourceSpecBuilder(Boolean validationEnabled) { 
        this(new AwsSqsSourceSpec(), validationEnabled);
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AwsSqsSourceSpec(), validationEnabled);
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,AwsSqsSourceSpec instance) { 
        this(fluent, instance, true);
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpecFluent<?> fluent,AwsSqsSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withAwsCredsSecret(instance.getAwsCredsSecret()); 
        fluent.withQueueUrl(instance.getQueueUrl()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpec instance) { 
        this(instance,true);
    }


    public AwsSqsSourceSpecBuilder(AwsSqsSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withAwsCredsSecret(instance.getAwsCredsSecret()); 
        this.withQueueUrl(instance.getQueueUrl()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public AwsSqsSourceSpec build() {
        AwsSqsSourceSpec buildable = new AwsSqsSourceSpec(fluent.getAnnotations(),fluent.getAwsCredsSecret(),fluent.getQueueUrl(),fluent.getServiceAccountName(),fluent.getSink());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AwsSqsSourceSpecBuilder that = (AwsSqsSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
