package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CouchDbSourceBuilder extends CouchDbSourceFluentImpl<CouchDbSourceBuilder> implements VisitableBuilder<CouchDbSource,CouchDbSourceBuilder> {

    CouchDbSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CouchDbSourceBuilder() { 
        this(true);
    }


    public CouchDbSourceBuilder(Boolean validationEnabled) { 
        this(new CouchDbSource(), validationEnabled);
    }


    public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CouchDbSource(), validationEnabled);
    }


    public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,CouchDbSource instance) { 
        this(fluent, instance, true);
    }


    public CouchDbSourceBuilder(CouchDbSourceFluent<?> fluent,CouchDbSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public CouchDbSourceBuilder(CouchDbSource instance) { 
        this(instance,true);
    }


    public CouchDbSourceBuilder(CouchDbSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public CouchDbSource build() {
        CouchDbSource buildable = new CouchDbSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CouchDbSourceBuilder that = (CouchDbSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
