package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretValueFromSourceBuilder extends SecretValueFromSourceFluentImpl<SecretValueFromSourceBuilder> implements VisitableBuilder<SecretValueFromSource,SecretValueFromSourceBuilder> {

    SecretValueFromSourceFluent<?> fluent;
    Boolean validationEnabled;

    public SecretValueFromSourceBuilder() { 
        this(true);
    }


    public SecretValueFromSourceBuilder(Boolean validationEnabled) { 
        this(new SecretValueFromSource(), validationEnabled);
    }


    public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SecretValueFromSource(), validationEnabled);
    }


    public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,SecretValueFromSource instance) { 
        this(fluent, instance, true);
    }


    public SecretValueFromSourceBuilder(SecretValueFromSourceFluent<?> fluent,SecretValueFromSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withSecretKeyRef(instance.getSecretKeyRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public SecretValueFromSourceBuilder(SecretValueFromSource instance) { 
        this(instance,true);
    }


    public SecretValueFromSourceBuilder(SecretValueFromSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withSecretKeyRef(instance.getSecretKeyRef()); 
        this.validationEnabled = validationEnabled; 
    }


    public SecretValueFromSource build() {
        SecretValueFromSource buildable = new SecretValueFromSource(fluent.getSecretKeyRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretValueFromSourceBuilder that = (SecretValueFromSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
