package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabSourceBuilder extends GitLabSourceFluentImpl<GitLabSourceBuilder> implements VisitableBuilder<GitLabSource,GitLabSourceBuilder> {

    GitLabSourceFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabSourceBuilder() { 
        this(true);
    }


    public GitLabSourceBuilder(Boolean validationEnabled) { 
        this(new GitLabSource(), validationEnabled);
    }


    public GitLabSourceBuilder(GitLabSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitLabSource(), validationEnabled);
    }


    public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,GitLabSource instance) { 
        this(fluent, instance, true);
    }


    public GitLabSourceBuilder(GitLabSourceFluent<?> fluent,GitLabSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabSourceBuilder(GitLabSource instance) { 
        this(instance,true);
    }


    public GitLabSourceBuilder(GitLabSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabSource build() {
        GitLabSource buildable = new GitLabSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabSourceBuilder that = (GitLabSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
