package io.fabric8.knative.eventing.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EventTypeListFluent<A extends EventTypeListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,EventType item);
    public A setToItems(int index,EventType item);
    public A addToItems(EventType... items);
    public A addAllToItems(Collection<EventType> items);
    public A removeFromItems(EventType... items);
    public A removeAllFromItems(Collection<EventType> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<EventTypeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<EventType> getItems();
    public List<EventType> buildItems();
    public EventType buildItem(int index);
    public EventType buildFirstItem();
    public EventType buildLastItem();
    public EventType buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EventTypeBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EventTypeBuilder> predicate);
    public A withItems(List<EventType> items);
    public A withItems(EventType... items);
    public Boolean hasItems();
    public EventTypeListFluent.ItemsNested<A> addNewItem();
    public EventTypeListFluent.ItemsNested<A> addNewItemLike(EventType item);
    public EventTypeListFluent.ItemsNested<A> setNewItemLike(int index,EventType item);
    public EventTypeListFluent.ItemsNested<A> editItem(int index);
    public EventTypeListFluent.ItemsNested<A> editFirstItem();
    public EventTypeListFluent.ItemsNested<A> editLastItem();
    public EventTypeListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<EventTypeBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventTypeFluent<EventTypeListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
