package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceStepBuilder extends SequenceStepFluentImpl<SequenceStepBuilder> implements VisitableBuilder<SequenceStep,SequenceStepBuilder> {

    SequenceStepFluent<?> fluent;
    Boolean validationEnabled;

    public SequenceStepBuilder() { 
        this(true);
    }


    public SequenceStepBuilder(Boolean validationEnabled) { 
        this(new SequenceStep(), validationEnabled);
    }


    public SequenceStepBuilder(SequenceStepFluent<?> fluent) { 
        this(fluent, true);
    }


    public SequenceStepBuilder(SequenceStepFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SequenceStep(), validationEnabled);
    }


    public SequenceStepBuilder(SequenceStepFluent<?> fluent,SequenceStep instance) { 
        this(fluent, instance, true);
    }


    public SequenceStepBuilder(SequenceStepFluent<?> fluent,SequenceStep instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDelivery(instance.getDelivery()); 
        fluent.withRef(instance.getRef()); 
        fluent.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public SequenceStepBuilder(SequenceStep instance) { 
        this(instance,true);
    }


    public SequenceStepBuilder(SequenceStep instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDelivery(instance.getDelivery()); 
        this.withRef(instance.getRef()); 
        this.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public SequenceStep build() {
        SequenceStep buildable = new SequenceStep(fluent.getDelivery(),fluent.getRef(),fluent.getUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SequenceStepBuilder that = (SequenceStepBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
