package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RevisionBuilder extends RevisionFluentImpl<RevisionBuilder> implements VisitableBuilder<Revision,RevisionBuilder> {

    RevisionFluent<?> fluent;
    Boolean validationEnabled;

    public RevisionBuilder() { 
        this(true);
    }


    public RevisionBuilder(Boolean validationEnabled) { 
        this(new Revision(), validationEnabled);
    }


    public RevisionBuilder(RevisionFluent<?> fluent) { 
        this(fluent, true);
    }


    public RevisionBuilder(RevisionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Revision(), validationEnabled);
    }


    public RevisionBuilder(RevisionFluent<?> fluent,Revision instance) { 
        this(fluent, instance, true);
    }


    public RevisionBuilder(RevisionFluent<?> fluent,Revision instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public RevisionBuilder(Revision instance) { 
        this(instance,true);
    }


    public RevisionBuilder(Revision instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public Revision build() {
        Revision buildable = new Revision(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RevisionBuilder that = (RevisionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
