package io.fabric8.knative.serving.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RevisionSpecFluent<A> {

    private Long activeDeadlineSeconds;
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private Long containerConcurrency;
    private List<Container> containers;
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private List<EphemeralContainer> ephemeralContainers;
    private List<HostAlias> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReference> imagePullSecrets;
    private List<Container> initContainers;
    private String nodeName;
    private Map<String,String> nodeSelector;
    private Map<String,Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private List<PodReadinessGate> readinessGates;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContext securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private Long timeoutSeconds;
    private List<Toleration> tolerations;
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    private List<Volume> volumes;

    public RevisionSpecFluentImpl() { 
    }


    public RevisionSpecFluentImpl(RevisionSpec instance) { 
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
        this.withAffinity(instance.getAffinity()); 
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
        this.withContainerConcurrency(instance.getContainerConcurrency()); 
        this.withContainers(instance.getContainers()); 
        this.withDnsConfig(instance.getDnsConfig()); 
        this.withDnsPolicy(instance.getDnsPolicy()); 
        this.withEnableServiceLinks(instance.getEnableServiceLinks()); 
        this.withEphemeralContainers(instance.getEphemeralContainers()); 
        this.withHostAliases(instance.getHostAliases()); 
        this.withHostIPC(instance.getHostIPC()); 
        this.withHostNetwork(instance.getHostNetwork()); 
        this.withHostPID(instance.getHostPID()); 
        this.withHostname(instance.getHostname()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withInitContainers(instance.getInitContainers()); 
        this.withNodeName(instance.getNodeName()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withOverhead(instance.getOverhead()); 
        this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
        this.withPriority(instance.getPriority()); 
        this.withPriorityClassName(instance.getPriorityClassName()); 
        this.withReadinessGates(instance.getReadinessGates()); 
        this.withRestartPolicy(instance.getRestartPolicy()); 
        this.withRuntimeClassName(instance.getRuntimeClassName()); 
        this.withSchedulerName(instance.getSchedulerName()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withShareProcessNamespace(instance.getShareProcessNamespace()); 
        this.withSubdomain(instance.getSubdomain()); 
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withTolerations(instance.getTolerations()); 
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
        this.withVolumes(instance.getVolumes()); 
    }


    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public Boolean isAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
    }

    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A withNewAutomountServiceAccountToken(String arg1) {
        return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public A withNewAutomountServiceAccountToken(boolean arg1) {
        return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency=containerConcurrency; return (A) this;
    }

    public Boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    public A addToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<Container>();}
        this.containers.add(index, item);
        return (A)this;
    }

    public A setToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<Container>();}
        this.containers.set(index, item); return (A)this;
    }

    public A addToContainers(Container... items) {
        if (this.containers == null) {this.containers = new ArrayList<Container>();}
        for (Container item : items) {this.containers.add(item);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {this.containers = new ArrayList<Container>();}
        for (Container item : items) {this.containers.add(item);} return (A)this;
    }

    public A removeFromContainers(Container... items) {
        for (Container item : items) {if (this.containers!= null){ this.containers.remove(item);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {if (this.containers!= null){ this.containers.remove(item);}} return (A)this;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public Container getContainer(int index) {
        return this.containers.get(index);
    }

    public Container getFirstContainer() {
        return this.containers.get(0);
    }

    public Container getLastContainer() {
        return this.containers.get(containers.size() - 1);
    }

    public Container getMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate) {
        for (Container item: containers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate) {
        for (Container item: containers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
        if (containers != null) {this.containers = new ArrayList<Container>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(Container... containers) {
        if (this.containers != null) {this.containers.clear();}
        if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers() {
        return containers != null && !containers.isEmpty();
    }

    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig=dnsConfig; return (A) this;
    }

    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy=dnsPolicy; return (A) this;
    }

    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public A withNewDnsPolicy(String arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public A withNewDnsPolicy(StringBuilder arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public A withNewDnsPolicy(StringBuffer arg1) {
        return (A)withDnsPolicy(new String(arg1));
    }

    public Boolean isEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks=enableServiceLinks; return (A) this;
    }

    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A withNewEnableServiceLinks(String arg1) {
        return (A)withEnableServiceLinks(new Boolean(arg1));
    }

    public A withNewEnableServiceLinks(boolean arg1) {
        return (A)withEnableServiceLinks(new Boolean(arg1));
    }

    public A addToEphemeralContainers(int index,EphemeralContainer item) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
        this.ephemeralContainers.add(index, item);
        return (A)this;
    }

    public A setToEphemeralContainers(int index,EphemeralContainer item) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
        this.ephemeralContainers.set(index, item); return (A)this;
    }

    public A addToEphemeralContainers(EphemeralContainer... items) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
        for (EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
    }

    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>();}
        for (EphemeralContainer item : items) {this.ephemeralContainers.add(item);} return (A)this;
    }

    public A removeFromEphemeralContainers(EphemeralContainer... items) {
        for (EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
    }

    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {if (this.ephemeralContainers!= null){ this.ephemeralContainers.remove(item);}} return (A)this;
    }

    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    public EphemeralContainer getEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index);
    }

    public EphemeralContainer getFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0);
    }

    public EphemeralContainer getLastEphemeralContainer() {
        return this.ephemeralContainers.get(ephemeralContainers.size() - 1);
    }

    public EphemeralContainer getMatchingEphemeralContainer(io.fabric8.kubernetes.api.builder.Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item: ephemeralContainers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingEphemeralContainer(io.fabric8.kubernetes.api.builder.Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item: ephemeralContainers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) { _visitables.get("ephemeralContainers").removeAll(this.ephemeralContainers);}
        if (ephemeralContainers != null) {this.ephemeralContainers = new ArrayList<EphemeralContainer>(); for (EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
    }

    public A withEphemeralContainers(EphemeralContainer... ephemeralContainers) {
        if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
        if (ephemeralContainers != null) {for (EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
    }

    public Boolean hasEphemeralContainers() {
        return ephemeralContainers != null && !ephemeralContainers.isEmpty();
    }

    public A addToHostAliases(int index,HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
        this.hostAliases.add(index, item);
        return (A)this;
    }

    public A setToHostAliases(int index,HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
        this.hostAliases.set(index, item); return (A)this;
    }

    public A addToHostAliases(HostAlias... items) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
        for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAlias>();}
        for (HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
    }

    public A removeFromHostAliases(HostAlias... items) {
        for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
    }

    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(hostAliases.size() - 1);
    }

    public HostAlias getMatchingHostAlias(io.fabric8.kubernetes.api.builder.Predicate<HostAlias> predicate) {
        for (HostAlias item: hostAliases) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHostAlias(io.fabric8.kubernetes.api.builder.Predicate<HostAlias> predicate) {
        for (HostAlias item: hostAliases) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) { _visitables.get("hostAliases").removeAll(this.hostAliases);}
        if (hostAliases != null) {this.hostAliases = new ArrayList<HostAlias>(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
    }

    public A withHostAliases(HostAlias... hostAliases) {
        if (this.hostAliases != null) {this.hostAliases.clear();}
        if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
    }

    public Boolean hasHostAliases() {
        return hostAliases != null && !hostAliases.isEmpty();
    }

    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public A withNewHostIPC(String arg1) {
        return (A)withHostIPC(new Boolean(arg1));
    }

    public A withNewHostIPC(boolean arg1) {
        return (A)withHostIPC(new Boolean(arg1));
    }

    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public A withNewHostNetwork(String arg1) {
        return (A)withHostNetwork(new Boolean(arg1));
    }

    public A withNewHostNetwork(boolean arg1) {
        return (A)withHostNetwork(new Boolean(arg1));
    }

    public Boolean isHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    public A withNewHostPID(String arg1) {
        return (A)withHostPID(new Boolean(arg1));
    }

    public A withNewHostPID(boolean arg1) {
        return (A)withHostPID(new Boolean(arg1));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname() {
        return this.hostname != null;
    }

    public A withNewHostname(String arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuilder arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A withNewHostname(StringBuffer arg1) {
        return (A)withHostname(new String(arg1));
    }

    public A addToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    public A setToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
        this.imagePullSecrets.set(index, item); return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
        for (LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>();}
        for (LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference... items) {
        for (LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public LocalObjectReference getImagePullSecret(int index) {
        return this.imagePullSecrets.get(index);
    }

    public LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    public LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1);
    }

    public LocalObjectReference getMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item: imagePullSecrets) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item: imagePullSecrets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList<LocalObjectReference>(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public A addToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<Container>();}
        this.initContainers.add(index, item);
        return (A)this;
    }

    public A setToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<Container>();}
        this.initContainers.set(index, item); return (A)this;
    }

    public A addToInitContainers(Container... items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<Container>();}
        for (Container item : items) {this.initContainers.add(item);} return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<Container>();}
        for (Container item : items) {this.initContainers.add(item);} return (A)this;
    }

    public A removeFromInitContainers(Container... items) {
        for (Container item : items) {if (this.initContainers!= null){ this.initContainers.remove(item);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {if (this.initContainers!= null){ this.initContainers.remove(item);}} return (A)this;
    }

    public List<Container> getInitContainers() {
        return this.initContainers;
    }

    public Container getInitContainer(int index) {
        return this.initContainers.get(index);
    }

    public Container getFirstInitContainer() {
        return this.initContainers.get(0);
    }

    public Container getLastInitContainer() {
        return this.initContainers.get(initContainers.size() - 1);
    }

    public Container getMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate) {
        for (Container item: initContainers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingInitContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate) {
        for (Container item: initContainers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
        if (initContainers != null) {this.initContainers = new ArrayList<Container>(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
    }

    public A withInitContainers(Container... initContainers) {
        if (this.initContainers != null) {this.initContainers.clear();}
        if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    public Boolean hasInitContainers() {
        return initContainers != null && !initContainers.isEmpty();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A withNewNodeName(String arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuilder arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuffer arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToOverhead(String key,Quantity value) {
        if(this.overhead == null && key != null && value != null) { this.overhead = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.overhead.put(key, value);} return (A)this;
    }

    public A addToOverhead(Map<String,Quantity> map) {
        if(this.overhead == null && map != null) { this.overhead = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.overhead.putAll(map);} return (A)this;
    }

    public A removeFromOverhead(String key) {
        if(this.overhead == null) { return (A) this; }
        if(key != null && this.overhead != null) {this.overhead.remove(key);} return (A)this;
    }

    public A removeFromOverhead(Map<String,Quantity> map) {
        if(this.overhead == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.overhead != null){this.overhead.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getOverhead() {
        return this.overhead;
    }

    public A withOverhead(Map<String,Quantity> overhead) {
        if (overhead == null) { this.overhead =  null;} else {this.overhead = new LinkedHashMap<String,Quantity>(overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy=preemptionPolicy; return (A) this;
    }

    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public A withNewPreemptionPolicy(String arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuilder arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public A withNewPreemptionPolicy(StringBuffer arg1) {
        return (A)withPreemptionPolicy(new String(arg1));
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority=priority; return (A) this;
    }

    public Boolean hasPriority() {
        return this.priority != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName=priorityClassName; return (A) this;
    }

    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A withNewPriorityClassName(String arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuilder arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuffer arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A addToReadinessGates(int index,PodReadinessGate item) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
        this.readinessGates.add(index, item);
        return (A)this;
    }

    public A setToReadinessGates(int index,PodReadinessGate item) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
        this.readinessGates.set(index, item); return (A)this;
    }

    public A addToReadinessGates(PodReadinessGate... items) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
        for (PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
    }

    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGate>();}
        for (PodReadinessGate item : items) {this.readinessGates.add(item);} return (A)this;
    }

    public A removeFromReadinessGates(PodReadinessGate... items) {
        for (PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
    }

    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {if (this.readinessGates!= null){ this.readinessGates.remove(item);}} return (A)this;
    }

    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    public PodReadinessGate getReadinessGate(int index) {
        return this.readinessGates.get(index);
    }

    public PodReadinessGate getFirstReadinessGate() {
        return this.readinessGates.get(0);
    }

    public PodReadinessGate getLastReadinessGate() {
        return this.readinessGates.get(readinessGates.size() - 1);
    }

    public PodReadinessGate getMatchingReadinessGate(io.fabric8.kubernetes.api.builder.Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item: readinessGates) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingReadinessGate(io.fabric8.kubernetes.api.builder.Predicate<PodReadinessGate> predicate) {
        for (PodReadinessGate item: readinessGates) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) { _visitables.get("readinessGates").removeAll(this.readinessGates);}
        if (readinessGates != null) {this.readinessGates = new ArrayList<PodReadinessGate>(); for (PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
    }

    public A withReadinessGates(PodReadinessGate... readinessGates) {
        if (this.readinessGates != null) {this.readinessGates.clear();}
        if (readinessGates != null) {for (PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
    }

    public Boolean hasReadinessGates() {
        return readinessGates != null && !readinessGates.isEmpty();
    }

    public A addNewReadinessGate(String conditionType) {
        return (A)addToReadinessGates(new PodReadinessGate(conditionType));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy=restartPolicy; return (A) this;
    }

    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public A withNewRestartPolicy(String arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(StringBuilder arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public A withNewRestartPolicy(StringBuffer arg1) {
        return (A)withRestartPolicy(new String(arg1));
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName=runtimeClassName; return (A) this;
    }

    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public A withNewRuntimeClassName(String arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public A withNewRuntimeClassName(StringBuilder arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public A withNewRuntimeClassName(StringBuffer arg1) {
        return (A)withRuntimeClassName(new String(arg1));
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName=schedulerName; return (A) this;
    }

    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public A withNewSchedulerName(String arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    public A withNewSchedulerName(StringBuilder arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    public A withNewSchedulerName(StringBuffer arg1) {
        return (A)withSchedulerName(new String(arg1));
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1) {
        return (A)withServiceAccount(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public Boolean isShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace=shareProcessNamespace; return (A) this;
    }

    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    public A withNewShareProcessNamespace(String arg1) {
        return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public A withNewShareProcessNamespace(boolean arg1) {
        return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain=subdomain; return (A) this;
    }

    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public A withNewSubdomain(String arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public A withNewSubdomain(StringBuilder arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public A withNewSubdomain(StringBuffer arg1) {
        return (A)withSubdomain(new String(arg1));
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }

    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
        this.topologySpreadConstraints.set(index, item); return (A)this;
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint... items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
        for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();}
        for (TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint... items) {
        for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
    }

    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
    }

    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(io.fabric8.kubernetes.api.builder.Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopologySpreadConstraint(io.fabric8.kubernetes.api.builder.Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) { _visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);}
        if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
        if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
    }

    public Boolean hasTopologySpreadConstraints() {
        return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    public Volume getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RevisionSpecFluentImpl that = (RevisionSpecFluentImpl) o;
        if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
        if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
        if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
        if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
        if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
        if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
        if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
        if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
        if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
        if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
        if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
        if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
        if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
        if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
        if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
        if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
        if (runtimeClassName != null ? !runtimeClassName.equals(that.runtimeClassName) :that.runtimeClassName != null) return false;
        if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
        if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
        if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(activeDeadlineSeconds,  affinity,  automountServiceAccountToken,  containerConcurrency,  containers,  dnsConfig,  dnsPolicy,  enableServiceLinks,  ephemeralContainers,  hostAliases,  hostIPC,  hostNetwork,  hostPID,  hostname,  imagePullSecrets,  initContainers,  nodeName,  nodeSelector,  overhead,  preemptionPolicy,  priority,  priorityClassName,  readinessGates,  restartPolicy,  runtimeClassName,  schedulerName,  securityContext,  serviceAccount,  serviceAccountName,  shareProcessNamespace,  subdomain,  terminationGracePeriodSeconds,  timeoutSeconds,  tolerations,  topologySpreadConstraints,  volumes,  super.hashCode());
    }

}
