package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteStatusBuilder extends RouteStatusFluentImpl<RouteStatusBuilder> implements VisitableBuilder<RouteStatus,RouteStatusBuilder> {

    RouteStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RouteStatusBuilder() { 
        this(true);
    }


    public RouteStatusBuilder(Boolean validationEnabled) { 
        this(new RouteStatus(), validationEnabled);
    }


    public RouteStatusBuilder(RouteStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public RouteStatusBuilder(RouteStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new RouteStatus(), validationEnabled);
    }


    public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance) { 
        this(fluent, instance, true);
    }


    public RouteStatusBuilder(RouteStatusFluent<?> fluent,RouteStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withTraffic(instance.getTraffic()); 
        fluent.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public RouteStatusBuilder(RouteStatus instance) { 
        this(instance,true);
    }


    public RouteStatusBuilder(RouteStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withTraffic(instance.getTraffic()); 
        this.withUrl(instance.getUrl()); 
        this.validationEnabled = validationEnabled; 
    }


    public RouteStatus build() {
        RouteStatus buildable = new RouteStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RouteStatusBuilder that = (RouteStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
