package io.fabric8.knative.sources.v1beta1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class APIVersionKindSelectorFluentImpl<A extends APIVersionKindSelectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements APIVersionKindSelectorFluent<A> {

    private String apiVersion;
    private String kind;
    private LabelSelector selector;

    public APIVersionKindSelectorFluentImpl() { 
    }


    public APIVersionKindSelectorFluentImpl(APIVersionKindSelector instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSelector(instance.getSelector()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public LabelSelector getSelector() {
        return this.selector;
    }

    public A withSelector(LabelSelector selector) {
        this.selector=selector; return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIVersionKindSelectorFluentImpl that = (APIVersionKindSelectorFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  selector,  super.hashCode());
    }

}
