package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerSourceListBuilder extends ContainerSourceListFluentImpl<ContainerSourceListBuilder> implements VisitableBuilder<ContainerSourceList,ContainerSourceListBuilder> {

    ContainerSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerSourceListBuilder() { 
        this(true);
    }


    public ContainerSourceListBuilder(Boolean validationEnabled) { 
        this(new ContainerSourceList(), validationEnabled);
    }


    public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ContainerSourceList(), validationEnabled);
    }


    public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,ContainerSourceList instance) { 
        this(fluent, instance, true);
    }


    public ContainerSourceListBuilder(ContainerSourceListFluent<?> fluent,ContainerSourceList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ContainerSourceListBuilder(ContainerSourceList instance) { 
        this(instance,true);
    }


    public ContainerSourceListBuilder(ContainerSourceList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ContainerSourceList build() {
        ContainerSourceList buildable = new ContainerSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerSourceListBuilder that = (ContainerSourceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
