package io.fabric8.knative.sources.v1beta1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributesFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventAttributes;
import java.lang.Boolean;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PingSourceStatusFluent<A extends PingSourceStatusFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public A addToCeAttributes(int index,CloudEventAttributes item);
    public A setToCeAttributes(int index,CloudEventAttributes item);
    public A addToCeAttributes(CloudEventAttributes... items);
    public A addAllToCeAttributes(Collection<CloudEventAttributes> items);
    public A removeFromCeAttributes(CloudEventAttributes... items);
    public A removeAllFromCeAttributes(Collection<CloudEventAttributes> items);
    public A removeMatchingFromCeAttributes(io.fabric8.kubernetes.api.builder.Predicate<CloudEventAttributesBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildCeAttributes instead.
 * @return The buildable object.
 */
@Deprecated public List<CloudEventAttributes> getCeAttributes();
    public List<CloudEventAttributes> buildCeAttributes();
    public CloudEventAttributes buildCeAttribute(int index);
    public CloudEventAttributes buildFirstCeAttribute();
    public CloudEventAttributes buildLastCeAttribute();
    public CloudEventAttributes buildMatchingCeAttribute(io.fabric8.kubernetes.api.builder.Predicate<CloudEventAttributesBuilder> predicate);
    public Boolean hasMatchingCeAttribute(io.fabric8.kubernetes.api.builder.Predicate<CloudEventAttributesBuilder> predicate);
    public A withCeAttributes(List<CloudEventAttributes> ceAttributes);
    public A withCeAttributes(CloudEventAttributes... ceAttributes);
    public Boolean hasCeAttributes();
    public A addNewCeAttribute(String source,String type);
    public PingSourceStatusFluent.CeAttributesNested<A> addNewCeAttribute();
    public PingSourceStatusFluent.CeAttributesNested<A> addNewCeAttributeLike(CloudEventAttributes item);
    public PingSourceStatusFluent.CeAttributesNested<A> setNewCeAttributeLike(int index,CloudEventAttributes item);
    public PingSourceStatusFluent.CeAttributesNested<A> editCeAttribute(int index);
    public PingSourceStatusFluent.CeAttributesNested<A> editFirstCeAttribute();
    public PingSourceStatusFluent.CeAttributesNested<A> editLastCeAttribute();
    public PingSourceStatusFluent.CeAttributesNested<A> editMatchingCeAttribute(io.fabric8.kubernetes.api.builder.Predicate<CloudEventAttributesBuilder> predicate);
    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public PingSourceStatusFluent.ConditionsNested<A> addNewCondition();
    public PingSourceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public PingSourceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public PingSourceStatusFluent.ConditionsNested<A> editCondition(int index);
    public PingSourceStatusFluent.ConditionsNested<A> editFirstCondition();
    public PingSourceStatusFluent.ConditionsNested<A> editLastCondition();
    public PingSourceStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public String getSinkUri();
    public A withSinkUri(String sinkUri);
    public Boolean hasSinkUri();
    public A withNewSinkUri(String arg1);
    public A withNewSinkUri(StringBuilder arg1);
    public A withNewSinkUri(StringBuffer arg1);
    public interface CeAttributesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CloudEventAttributesFluent<PingSourceStatusFluent.CeAttributesNested<N>> {

        public N and();
        public N endCeAttribute();    }


    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<PingSourceStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


}
