package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaBindingListFluent<A extends KafkaBindingListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KafkaBinding item);
    public A setToItems(int index,KafkaBinding item);
    public A addToItems(KafkaBinding... items);
    public A addAllToItems(Collection<KafkaBinding> items);
    public A removeFromItems(KafkaBinding... items);
    public A removeAllFromItems(Collection<KafkaBinding> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<KafkaBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KafkaBinding> getItems();
    public List<KafkaBinding> buildItems();
    public KafkaBinding buildItem(int index);
    public KafkaBinding buildFirstItem();
    public KafkaBinding buildLastItem();
    public KafkaBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KafkaBindingBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KafkaBindingBuilder> predicate);
    public A withItems(List<KafkaBinding> items);
    public A withItems(KafkaBinding... items);
    public Boolean hasItems();
    public KafkaBindingListFluent.ItemsNested<A> addNewItem();
    public KafkaBindingListFluent.ItemsNested<A> addNewItemLike(KafkaBinding item);
    public KafkaBindingListFluent.ItemsNested<A> setNewItemLike(int index,KafkaBinding item);
    public KafkaBindingListFluent.ItemsNested<A> editItem(int index);
    public KafkaBindingListFluent.ItemsNested<A> editFirstItem();
    public KafkaBindingListFluent.ItemsNested<A> editLastItem();
    public KafkaBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KafkaBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBindingFluent<KafkaBindingListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
