package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;

public class SecretValueFromSourceFluentImpl<A extends io.fabric8.knative.eventing.contrib.kafka.v1beta1.SecretValueFromSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.eventing.contrib.kafka.v1beta1.SecretValueFromSourceFluent<A> {

    private SecretKeySelector secretKeyRef;

    public SecretValueFromSourceFluentImpl() { 
    }


    public SecretValueFromSourceFluentImpl(io.fabric8.knative.eventing.contrib.kafka.v1beta1.SecretValueFromSource instance) { 
        this.withSecretKeyRef(instance.getSecretKeyRef()); 
    }


    public SecretKeySelector getSecretKeyRef() {
        return this.secretKeyRef;
    }

    public A withSecretKeyRef(SecretKeySelector secretKeyRef) {
        this.secretKeyRef=secretKeyRef; return (A) this;
    }

    public Boolean hasSecretKeyRef() {
        return this.secretKeyRef != null;
    }

    public A withNewSecretKeyRef(String key,String name,Boolean optional) {
        return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecretValueFromSourceFluentImpl that = (SecretValueFromSourceFluentImpl) o;
        if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(secretKeyRef,  super.hashCode());
    }

}
