
package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "credentials",
    "database",
    "feed",
    "serviceAccountName",
    "sink"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class CouchDbSourceSpec implements KubernetesResource
{

    @JsonProperty("credentials")
    private ObjectReference credentials;
    /**
     * 
     * 
     */
    @JsonProperty("database")
    private String database;
    /**
     * 
     * 
     */
    @JsonProperty("feed")
    private String feed;
    /**
     * 
     * 
     */
    @JsonProperty("serviceAccountName")
    private String serviceAccountName;
    /**
     * 
     * 
     */
    @JsonProperty("sink")
    private Destination sink;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public CouchDbSourceSpec() {
    }

    /**
     * 
     * @param feed
     * @param database
     * @param credentials
     * @param serviceAccountName
     * @param sink
     */
    public CouchDbSourceSpec(ObjectReference credentials, String database, String feed, String serviceAccountName, Destination sink) {
        this.credentials = credentials;
        this.database = database;
        this.feed = feed;
        this.serviceAccountName = serviceAccountName;
        this.sink = sink;
    }

    /**
     * 
     * @return
     *     The credentials
     */
    @JsonProperty("credentials")
    public ObjectReference getCredentials() {
        return credentials;
    }

    /**
     * 
     * @param credentials
     *     The credentials
     */
    @JsonProperty("credentials")
    public void setCredentials(ObjectReference credentials) {
        this.credentials = credentials;
    }

    /**
     * 
     * 
     * @return
     *     The database
     */
    @JsonProperty("database")
    public String getDatabase() {
        return database;
    }

    /**
     * 
     * 
     * @param database
     *     The database
     */
    @JsonProperty("database")
    public void setDatabase(String database) {
        this.database = database;
    }

    /**
     * 
     * 
     * @return
     *     The feed
     */
    @JsonProperty("feed")
    public String getFeed() {
        return feed;
    }

    /**
     * 
     * 
     * @param feed
     *     The feed
     */
    @JsonProperty("feed")
    public void setFeed(String feed) {
        this.feed = feed;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public String getServiceAccountName() {
        return serviceAccountName;
    }

    /**
     * 
     * 
     * @param serviceAccountName
     *     The serviceAccountName
     */
    @JsonProperty("serviceAccountName")
    public void setServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    /**
     * 
     * 
     * @return
     *     The sink
     */
    @JsonProperty("sink")
    public Destination getSink() {
        return sink;
    }

    /**
     * 
     * 
     * @param sink
     *     The sink
     */
    @JsonProperty("sink")
    public void setSink(Destination sink) {
        this.sink = sink;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
