package io.fabric8.knative.internal.pkg.tracker;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReferenceBuilder extends ReferenceFluentImpl<ReferenceBuilder> implements VisitableBuilder<Reference,ReferenceBuilder> {

    ReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ReferenceBuilder() { 
        this(true);
    }


    public ReferenceBuilder(Boolean validationEnabled) { 
        this(new Reference(), validationEnabled);
    }


    public ReferenceBuilder(ReferenceFluent<?> fluent) { 
        this(fluent, true);
    }


    public ReferenceBuilder(ReferenceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Reference(), validationEnabled);
    }


    public ReferenceBuilder(ReferenceFluent<?> fluent,Reference instance) { 
        this(fluent, instance, true);
    }


    public ReferenceBuilder(ReferenceFluent<?> fluent,Reference instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }


    public ReferenceBuilder(Reference instance) { 
        this(instance,true);
    }


    public ReferenceBuilder(Reference instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.internal.pkg.tracker.EditableReference build() {
        EditableReference buildable = new EditableReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReferenceBuilder that = (ReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
