package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TriggerFilterSourceAndTypeBuilder extends TriggerFilterSourceAndTypeFluentImpl<TriggerFilterSourceAndTypeBuilder> implements VisitableBuilder<TriggerFilterSourceAndType,TriggerFilterSourceAndTypeBuilder>{

    TriggerFilterSourceAndTypeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TriggerFilterSourceAndTypeBuilder(){
            this(true);
    }
    public TriggerFilterSourceAndTypeBuilder(Boolean validationEnabled){
            this(new TriggerFilterSourceAndType(), validationEnabled);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndTypeFluent<?> fluent){
            this(fluent, true);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TriggerFilterSourceAndType(), validationEnabled);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndTypeFluent<?> fluent,TriggerFilterSourceAndType instance){
            this(fluent, instance, true);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndTypeFluent<?> fluent,TriggerFilterSourceAndType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSource(instance.getSource()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndType instance){
            this(instance,true);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSource(instance.getSource()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerFilterSourceAndTypeBuilder(Validator validator){
            this(new TriggerFilterSourceAndType(), true);
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndTypeFluent<?> fluent,TriggerFilterSourceAndType instance,Validator validator){
            this.fluent = fluent; 
            fluent.withSource(instance.getSource()); 
            fluent.withType(instance.getType()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TriggerFilterSourceAndTypeBuilder(TriggerFilterSourceAndType instance,Validator validator){
            this.fluent = this; 
            this.withSource(instance.getSource()); 
            this.withType(instance.getType()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TriggerFilterSourceAndType build(){
            TriggerFilterSourceAndType buildable = new TriggerFilterSourceAndType(fluent.getSource(),fluent.getType());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerFilterSourceAndTypeBuilder that = (TriggerFilterSourceAndTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
