package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.knative.v1.Condition;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceChannelStatusFluentImpl<A extends SequenceChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceChannelStatusFluent<A>{

    private ObjectReference channel;
    private ConditionBuilder ready;

    public SequenceChannelStatusFluentImpl(){
    }
    public SequenceChannelStatusFluentImpl(SequenceChannelStatus instance){
            this.withChannel(instance.getChannel()); 
            this.withReady(instance.getReady()); 
    }

    public ObjectReference getChannel(){
            return this.channel;
    }

    public A withChannel(ObjectReference channel){
            this.channel=channel; return (A) this;
    }

    public Boolean hasChannel(){
            return this.channel != null;
    }

    
/**
 * This method has been deprecated, please use method buildReady instead.
 * @return The buildable object.
 */
@Deprecated public Condition getReady(){
            return this.ready!=null?this.ready.build():null;
    }

    public Condition buildReady(){
            return this.ready!=null?this.ready.build():null;
    }

    public A withReady(Condition ready){
            _visitables.get("ready").remove(this.ready);
            if (ready!=null){ this.ready= new ConditionBuilder(ready); _visitables.get("ready").add(this.ready);} return (A) this;
    }

    public Boolean hasReady(){
            return this.ready != null;
    }

    public SequenceChannelStatusFluent.ReadyNested<A> withNewReady(){
            return new ReadyNestedImpl();
    }

    public SequenceChannelStatusFluent.ReadyNested<A> withNewReadyLike(Condition item){
            return new ReadyNestedImpl(item);
    }

    public SequenceChannelStatusFluent.ReadyNested<A> editReady(){
            return withNewReadyLike(getReady());
    }

    public SequenceChannelStatusFluent.ReadyNested<A> editOrNewReady(){
            return withNewReadyLike(getReady() != null ? getReady(): new ConditionBuilder().build());
    }

    public SequenceChannelStatusFluent.ReadyNested<A> editOrNewReadyLike(Condition item){
            return withNewReadyLike(getReady() != null ? getReady(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SequenceChannelStatusFluentImpl that = (SequenceChannelStatusFluentImpl) o;
            if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
            if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
            return true;
    }


    public class ReadyNestedImpl<N> extends ConditionFluentImpl<SequenceChannelStatusFluent.ReadyNested<N>> implements SequenceChannelStatusFluent.ReadyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
    
            ReadyNestedImpl(Condition item){
                    this.builder = new ConditionBuilder(this, item);
            }
            ReadyNestedImpl(){
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) SequenceChannelStatusFluentImpl.this.withReady(builder.build());
    }
    public N endReady(){
            return and();
    }

}


}
