
package io.fabric8.knative.eventing.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.duck.v1alpha1.Addressable;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "address",
    "conditions",
    "ingressChannel",
    "observedGeneration",
    "triggerChannel"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class BrokerStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @Valid
    private Addressable address;
    /**
     * 
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<Condition> conditions = new ArrayList<Condition>();
    /**
     * 
     * 
     */
    @JsonProperty("ingressChannel")
    @Valid
    private ObjectReference ingressChannel;
    /**
     * 
     * 
     */
    @JsonProperty("observedGeneration")
    private Long observedGeneration;
    /**
     * 
     * 
     */
    @JsonProperty("triggerChannel")
    @Valid
    private ObjectReference triggerChannel;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BrokerStatus() {
    }

    /**
     * 
     * @param address
     * @param triggerChannel
     * @param ingressChannel
     * @param conditions
     * @param observedGeneration
     */
    public BrokerStatus(Addressable address, List<Condition> conditions, ObjectReference ingressChannel, Long observedGeneration, ObjectReference triggerChannel) {
        this.address = address;
        this.conditions = conditions;
        this.ingressChannel = ingressChannel;
        this.observedGeneration = observedGeneration;
        this.triggerChannel = triggerChannel;
    }

    /**
     * 
     * 
     * @return
     *     The address
     */
    @JsonProperty("address")
    public Addressable getAddress() {
        return address;
    }

    /**
     * 
     * 
     * @param address
     *     The address
     */
    @JsonProperty("address")
    public void setAddress(Addressable address) {
        this.address = address;
    }

    /**
     * 
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    /**
     * 
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The ingressChannel
     */
    @JsonProperty("ingressChannel")
    public ObjectReference getIngressChannel() {
        return ingressChannel;
    }

    /**
     * 
     * 
     * @param ingressChannel
     *     The ingressChannel
     */
    @JsonProperty("ingressChannel")
    public void setIngressChannel(ObjectReference ingressChannel) {
        this.ingressChannel = ingressChannel;
    }

    /**
     * 
     * 
     * @return
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    /**
     * 
     * 
     * @param observedGeneration
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    /**
     * 
     * 
     * @return
     *     The triggerChannel
     */
    @JsonProperty("triggerChannel")
    public ObjectReference getTriggerChannel() {
        return triggerChannel;
    }

    /**
     * 
     * 
     * @param triggerChannel
     *     The triggerChannel
     */
    @JsonProperty("triggerChannel")
    public void setTriggerChannel(ObjectReference triggerChannel) {
        this.triggerChannel = triggerChannel;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
