package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ChannelBuilder extends ChannelFluentImpl<ChannelBuilder> implements VisitableBuilder<Channel,ChannelBuilder>{

    ChannelFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ChannelBuilder(){
            this(true);
    }
    public ChannelBuilder(Boolean validationEnabled){
            this(new Channel(), validationEnabled);
    }
    public ChannelBuilder(ChannelFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelBuilder(ChannelFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Channel(), validationEnabled);
    }
    public ChannelBuilder(ChannelFluent<?> fluent,Channel instance){
            this(fluent, instance, true);
    }
    public ChannelBuilder(ChannelFluent<?> fluent,Channel instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelBuilder(Channel instance){
            this(instance,true);
    }
    public ChannelBuilder(Channel instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelBuilder(Validator validator){
            this(new Channel(), true);
    }
    public ChannelBuilder(ChannelFluent<?> fluent,Channel instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ChannelBuilder(Channel instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Channel build(){
            Channel buildable = new Channel(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelBuilder that = (ChannelBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
