package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TriggerSpecBuilder extends TriggerSpecFluentImpl<TriggerSpecBuilder> implements VisitableBuilder<TriggerSpec,TriggerSpecBuilder>{

    TriggerSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TriggerSpecBuilder(){
            this(true);
    }
    public TriggerSpecBuilder(Boolean validationEnabled){
            this(new TriggerSpec(), validationEnabled);
    }
    public TriggerSpecBuilder(TriggerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TriggerSpec(), validationEnabled);
    }
    public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance){
            this(fluent, instance, true);
    }
    public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker()); 
            fluent.withFilter(instance.getFilter()); 
            fluent.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerSpecBuilder(TriggerSpec instance){
            this(instance,true);
    }
    public TriggerSpecBuilder(TriggerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBroker(instance.getBroker()); 
            this.withFilter(instance.getFilter()); 
            this.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerSpecBuilder(Validator validator){
            this(new TriggerSpec(), true);
    }
    public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker()); 
            fluent.withFilter(instance.getFilter()); 
            fluent.withSubscriber(instance.getSubscriber()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TriggerSpecBuilder(TriggerSpec instance,Validator validator){
            this.fluent = this; 
            this.withBroker(instance.getBroker()); 
            this.withFilter(instance.getFilter()); 
            this.withSubscriber(instance.getSubscriber()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TriggerSpec build(){
            TriggerSpec buildable = new TriggerSpec(fluent.getBroker(),fluent.getFilter(),fluent.getSubscriber());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerSpecBuilder that = (TriggerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
