package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class InMemoryChannelSpecBuilder extends InMemoryChannelSpecFluentImpl<InMemoryChannelSpecBuilder> implements VisitableBuilder<InMemoryChannelSpec,InMemoryChannelSpecBuilder>{

    InMemoryChannelSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public InMemoryChannelSpecBuilder(){
            this(true);
    }
    public InMemoryChannelSpecBuilder(Boolean validationEnabled){
            this(new InMemoryChannelSpec(), validationEnabled);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent){
            this(fluent, true);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InMemoryChannelSpec(), validationEnabled);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance){
            this(fluent, instance, true);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance){
            this(instance,true);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public InMemoryChannelSpecBuilder(Validator validator){
            this(new InMemoryChannelSpec(), true);
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpecFluent<?> fluent,InMemoryChannelSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public InMemoryChannelSpecBuilder(InMemoryChannelSpec instance,Validator validator){
            this.fluent = this; 
            this.withSubscribable(instance.getSubscribable()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public InMemoryChannelSpec build(){
            InMemoryChannelSpec buildable = new InMemoryChannelSpec(fluent.getSubscribable());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InMemoryChannelSpecBuilder that = (InMemoryChannelSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
