
package io.fabric8.knative.messaging.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.eventing.v1alpha1.SubscriberSpec;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "channelTemplate",
    "reply",
    "steps"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SequenceSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("channelTemplate")
    @Valid
    private ChannelTemplateSpec channelTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("reply")
    @Valid
    private ObjectReference reply;
    /**
     * 
     * 
     */
    @JsonProperty("steps")
    @Valid
    private List<SubscriberSpec> steps = new ArrayList<SubscriberSpec>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SequenceSpec() {
    }

    /**
     * 
     * @param reply
     * @param channelTemplate
     * @param steps
     */
    public SequenceSpec(ChannelTemplateSpec channelTemplate, ObjectReference reply, List<SubscriberSpec> steps) {
        this.channelTemplate = channelTemplate;
        this.reply = reply;
        this.steps = steps;
    }

    /**
     * 
     * 
     * @return
     *     The channelTemplate
     */
    @JsonProperty("channelTemplate")
    public ChannelTemplateSpec getChannelTemplate() {
        return channelTemplate;
    }

    /**
     * 
     * 
     * @param channelTemplate
     *     The channelTemplate
     */
    @JsonProperty("channelTemplate")
    public void setChannelTemplate(ChannelTemplateSpec channelTemplate) {
        this.channelTemplate = channelTemplate;
    }

    /**
     * 
     * 
     * @return
     *     The reply
     */
    @JsonProperty("reply")
    public ObjectReference getReply() {
        return reply;
    }

    /**
     * 
     * 
     * @param reply
     *     The reply
     */
    @JsonProperty("reply")
    public void setReply(ObjectReference reply) {
        this.reply = reply;
    }

    /**
     * 
     * 
     * @return
     *     The steps
     */
    @JsonProperty("steps")
    public List<SubscriberSpec> getSteps() {
        return steps;
    }

    /**
     * 
     * 
     * @param steps
     *     The steps
     */
    @JsonProperty("steps")
    public void setSteps(List<SubscriberSpec> steps) {
        this.steps = steps;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
