package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ConfigurationSpecBuilder extends ConfigurationSpecFluentImpl<ConfigurationSpecBuilder> implements VisitableBuilder<ConfigurationSpec,ConfigurationSpecBuilder>{

    ConfigurationSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigurationSpecBuilder(){
            this(true);
    }
    public ConfigurationSpecBuilder(Boolean validationEnabled){
            this(new ConfigurationSpec(), validationEnabled);
    }
    public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConfigurationSpec(), validationEnabled);
    }
    public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,ConfigurationSpec instance){
            this(fluent, instance, true);
    }
    public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,ConfigurationSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationSpecBuilder(ConfigurationSpec instance){
            this(instance,true);
    }
    public ConfigurationSpecBuilder(ConfigurationSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationSpecBuilder(Validator validator){
            this(new ConfigurationSpec(), true);
    }
    public ConfigurationSpecBuilder(ConfigurationSpecFluent<?> fluent,ConfigurationSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withTemplate(instance.getTemplate()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ConfigurationSpecBuilder(ConfigurationSpec instance,Validator validator){
            this.fluent = this; 
            this.withTemplate(instance.getTemplate()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ConfigurationSpec build(){
            ConfigurationSpec buildable = new ConfigurationSpec(fluent.getTemplate());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigurationSpecBuilder that = (ConfigurationSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
