package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RevisionSpecFluent<A>{

    private Long containerConcurrency;
    private List<Container> containers;
    private String serviceAccountName;
    private Long timeoutSeconds;
    private List<Volume> volumes;

    public RevisionSpecFluentImpl(){
    }
    public RevisionSpecFluentImpl(RevisionSpec instance){
            this.withContainerConcurrency(instance.getContainerConcurrency()); 
            this.withContainers(instance.getContainers()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public Long getContainerConcurrency(){
            return this.containerConcurrency;
    }

    public A withContainerConcurrency(Long containerConcurrency){
            this.containerConcurrency=containerConcurrency; return (A) this;
    }

    public Boolean hasContainerConcurrency(){
            return this.containerConcurrency != null;
    }

    public A addToContainers(int index,Container item){
            if (this.containers == null) {this.containers = new ArrayList<Container>();}
            this.containers.add(index, item);
            return (A)this;
    }

    public A setToContainers(int index,Container item){
            if (this.containers == null) {this.containers = new ArrayList<Container>();}
            this.containers.set(index, item); return (A)this;
    }

    public A addToContainers(Container... items){
            if (this.containers == null) {this.containers = new ArrayList<Container>();}
            for (Container item : items) {this.containers.add(item);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items){
            if (this.containers == null) {this.containers = new ArrayList<Container>();}
            for (Container item : items) {this.containers.add(item);} return (A)this;
    }

    public A removeFromContainers(Container... items){
            for (Container item : items) {if (this.containers!= null){ this.containers.remove(item);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items){
            for (Container item : items) {if (this.containers!= null){ this.containers.remove(item);}} return (A)this;
    }

    public List<Container> getContainers(){
            return this.containers;
    }

    public Container getContainer(int index){
            return this.containers.get(index);
    }

    public Container getFirstContainer(){
            return this.containers.get(0);
    }

    public Container getLastContainer(){
            return this.containers.get(containers.size() - 1);
    }

    public Container getMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate){
            for (Container item: containers) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<Container> predicate){
            for (Container item: containers) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withContainers(List<Container> containers){
            if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
            if (containers != null) {this.containers = new ArrayList<Container>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = new ArrayList<Container>();} return (A) this;
    }

    public A withContainers(Container... containers){
            if (this.containers != null) {this.containers.clear();}
            if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers(){
            return containers != null && !containers.isEmpty();
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public Long getTimeoutSeconds(){
            return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Long timeoutSeconds){
            this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds(){
            return this.timeoutSeconds != null;
    }

    public A addToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            this.volumes.add(index, item);
            return (A)this;
    }

    public A setToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items){
            if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
            for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items){
            for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes(){
            return this.volumes;
    }

    public Volume getVolume(int index){
            return this.volumes.get(index);
    }

    public Volume getFirstVolume(){
            return this.volumes.get(0);
    }

    public Volume getLastVolume(){
            return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate){
            for (Volume item: volumes) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<Volume> predicate){
            for (Volume item: volumes) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes){
            if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = new ArrayList<Volume>();} return (A) this;
    }

    public A withVolumes(Volume... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RevisionSpecFluentImpl that = (RevisionSpecFluentImpl) o;
            if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
            if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }




}
