package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubscribableStatusBuilder extends SubscribableStatusFluentImpl<SubscribableStatusBuilder> implements VisitableBuilder<SubscribableStatus,SubscribableStatusBuilder>{

    SubscribableStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubscribableStatusBuilder(){
            this(true);
    }
    public SubscribableStatusBuilder(Boolean validationEnabled){
            this(new SubscribableStatus(), validationEnabled);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableStatus(), validationEnabled);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,SubscribableStatus instance){
            this(fluent, instance, true);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,SubscribableStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableStatusBuilder(SubscribableStatus instance){
            this(instance,true);
    }
    public SubscribableStatusBuilder(SubscribableStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableStatusBuilder(Validator validator){
            this(new SubscribableStatus(), true);
    }
    public SubscribableStatusBuilder(SubscribableStatusFluent<?> fluent,SubscribableStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubscribableStatusBuilder(SubscribableStatus instance,Validator validator){
            this.fluent = this; 
            this.withSubscribers(instance.getSubscribers()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubscribableStatus build(){
            SubscribableStatus buildable = new SubscribableStatus(fluent.getSubscribers());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableStatusBuilder that = (SubscribableStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
