package io.fabric8.knative.duck.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SubscribableStatusFluent<A extends SubscribableStatusFluent<A>> extends Fluent<A>{


    public A addToSubscribers(int index,SubscriberStatus item);
    public A setToSubscribers(int index,SubscriberStatus item);
    public A addToSubscribers(SubscriberStatus... items);
    public A addAllToSubscribers(Collection<SubscriberStatus> items);
    public A removeFromSubscribers(SubscriberStatus... items);
    public A removeAllFromSubscribers(Collection<SubscriberStatus> items);
    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriberStatus> getSubscribers();
    public List<SubscriberStatus> buildSubscribers();
    public SubscriberStatus buildSubscriber(int index);
    public SubscriberStatus buildFirstSubscriber();
    public SubscriberStatus buildLastSubscriber();
    public SubscriberStatus buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate);
    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate);
    public A withSubscribers(List<SubscriberStatus> subscribers);
    public A withSubscribers(SubscriberStatus... subscribers);
    public Boolean hasSubscribers();
    public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid);
    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriber();
    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item);
    public SubscribableStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberStatus item);
    public SubscribableStatusFluent.SubscribersNested<A> editSubscriber(int index);
    public SubscribableStatusFluent.SubscribersNested<A> editFirstSubscriber();
    public SubscribableStatusFluent.SubscribersNested<A> editLastSubscriber();
    public SubscribableStatusFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate);

    public interface SubscribersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SubscriberStatusFluent<SubscribableStatusFluent.SubscribersNested<N>>{

        
    public N and();    public N endSubscriber();
}


}
