package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BrokerStatusBuilder extends BrokerStatusFluentImpl<BrokerStatusBuilder> implements VisitableBuilder<BrokerStatus,BrokerStatusBuilder>{

    BrokerStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BrokerStatusBuilder(){
            this(true);
    }
    public BrokerStatusBuilder(Boolean validationEnabled){
            this(new BrokerStatus(), validationEnabled);
    }
    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BrokerStatus(), validationEnabled);
    }
    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance){
            this(fluent, instance, true);
    }
    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withIngressChannel(instance.getIngressChannel()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withTriggerChannel(instance.getTriggerChannel()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerStatusBuilder(BrokerStatus instance){
            this(instance,true);
    }
    public BrokerStatusBuilder(BrokerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withIngressChannel(instance.getIngressChannel()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withTriggerChannel(instance.getTriggerChannel()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerStatusBuilder(Validator validator){
            this(new BrokerStatus(), true);
    }
    public BrokerStatusBuilder(BrokerStatusFluent<?> fluent,BrokerStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withIngressChannel(instance.getIngressChannel()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withTriggerChannel(instance.getTriggerChannel()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BrokerStatusBuilder(BrokerStatus instance,Validator validator){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withIngressChannel(instance.getIngressChannel()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withTriggerChannel(instance.getTriggerChannel()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BrokerStatus build(){
            BrokerStatus buildable = new BrokerStatus(fluent.getAddress(),fluent.getConditions(),fluent.getIngressChannel(),fluent.getObservedGeneration(),fluent.getTriggerChannel());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BrokerStatusBuilder that = (BrokerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
