package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;

public class SubscriptionFluentImpl<A extends SubscriptionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private SubscriptionSpecBuilder spec;
    private SubscriptionStatusBuilder status;

    public SubscriptionFluentImpl(){
    }
    public SubscriptionFluentImpl(Subscription instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public SubscriptionFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public SubscriptionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public SubscriptionFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public SubscriptionFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public SubscriptionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SubscriptionSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public SubscriptionSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(SubscriptionSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new SubscriptionSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public SubscriptionFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public SubscriptionFluent.SpecNested<A> withNewSpecLike(SubscriptionSpec item){
            return new SpecNestedImpl(item);
    }

    public SubscriptionFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public SubscriptionFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new SubscriptionSpecBuilder().build());
    }

    public SubscriptionFluent.SpecNested<A> editOrNewSpecLike(SubscriptionSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public SubscriptionStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public SubscriptionStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(SubscriptionStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new SubscriptionStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public SubscriptionFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public SubscriptionFluent.StatusNested<A> withNewStatusLike(SubscriptionStatus item){
            return new StatusNestedImpl(item);
    }

    public SubscriptionFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public SubscriptionFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new SubscriptionStatusBuilder().build());
    }

    public SubscriptionFluent.StatusNested<A> editOrNewStatusLike(SubscriptionStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionFluentImpl that = (SubscriptionFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<SubscriptionFluent.MetadataNested<N>> implements SubscriptionFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends SubscriptionSpecFluentImpl<SubscriptionFluent.SpecNested<N>> implements SubscriptionFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriptionSpecBuilder builder;
    
            SpecNestedImpl(SubscriptionSpec item){
                    this.builder = new SubscriptionSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new SubscriptionSpecBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends SubscriptionStatusFluentImpl<SubscriptionFluent.StatusNested<N>> implements SubscriptionFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriptionStatusBuilder builder;
    
            StatusNestedImpl(SubscriptionStatus item){
                    this.builder = new SubscriptionStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new SubscriptionStatusBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
