package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface SubscriptionSpecFluent<A extends SubscriptionSpecFluent<A>> extends Fluent<A>{


    public ObjectReference getChannel();
    public A withChannel(ObjectReference channel);
    public Boolean hasChannel();
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@Deprecated public ReplyStrategy getReply();
    public ReplyStrategy buildReply();
    public A withReply(ReplyStrategy reply);
    public Boolean hasReply();
    public SubscriptionSpecFluent.ReplyNested<A> withNewReply();
    public SubscriptionSpecFluent.ReplyNested<A> withNewReplyLike(ReplyStrategy item);
    public SubscriptionSpecFluent.ReplyNested<A> editReply();
    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReply();
    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReplyLike(ReplyStrategy item);
    
/**
 * This method has been deprecated, please use method buildSubscriber instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec getSubscriber();
    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildSubscriber();
    public A withSubscriber(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec subscriber);
    public Boolean hasSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item);
    public SubscriptionSpecFluent.SubscriberNested<A> editSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriber();
    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item);

    public interface ReplyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplyStrategyFluent<SubscriptionSpecFluent.ReplyNested<N>>{

        
    public N and();    public N endReply();
}
    public interface SubscriberNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<SubscriptionSpecFluent.SubscriberNested<N>>{

        
    public N and();    public N endSubscriber();
}


}
