package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubscriptionStatusBuilder extends SubscriptionStatusFluentImpl<SubscriptionStatusBuilder> implements VisitableBuilder<SubscriptionStatus,SubscriptionStatusBuilder>{

    SubscriptionStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubscriptionStatusBuilder(){
            this(true);
    }
    public SubscriptionStatusBuilder(Boolean validationEnabled){
            this(new SubscriptionStatus(), validationEnabled);
    }
    public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriptionStatus(), validationEnabled);
    }
    public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance){
            this(fluent, instance, true);
    }
    public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withPhysicalSubscription(instance.getPhysicalSubscription()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionStatusBuilder(SubscriptionStatus instance){
            this(instance,true);
    }
    public SubscriptionStatusBuilder(SubscriptionStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withPhysicalSubscription(instance.getPhysicalSubscription()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionStatusBuilder(Validator validator){
            this(new SubscriptionStatus(), true);
    }
    public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withPhysicalSubscription(instance.getPhysicalSubscription()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubscriptionStatusBuilder(SubscriptionStatus instance,Validator validator){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withPhysicalSubscription(instance.getPhysicalSubscription()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubscriptionStatus build(){
            SubscriptionStatus buildable = new SubscriptionStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.getPhysicalSubscription());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionStatusBuilder that = (SubscriptionStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
