package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerSpecFluent<A>{

    private String broker;
    private TriggerFilterBuilder filter;
    private io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder subscriber;

    public TriggerSpecFluentImpl(){
    }
    public TriggerSpecFluentImpl(TriggerSpec instance){
            this.withBroker(instance.getBroker()); 
            this.withFilter(instance.getFilter()); 
            this.withSubscriber(instance.getSubscriber()); 
    }

    public String getBroker(){
            return this.broker;
    }

    public A withBroker(String broker){
            this.broker=broker; return (A) this;
    }

    public Boolean hasBroker(){
            return this.broker != null;
    }

    public A withNewBroker(String arg1){
            return (A)withBroker(new String(arg1));
    }

    public A withNewBroker(StringBuilder arg1){
            return (A)withBroker(new String(arg1));
    }

    public A withNewBroker(StringBuffer arg1){
            return (A)withBroker(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildFilter instead.
 * @return The buildable object.
 */
@Deprecated public TriggerFilter getFilter(){
            return this.filter!=null?this.filter.build():null;
    }

    public TriggerFilter buildFilter(){
            return this.filter!=null?this.filter.build():null;
    }

    public A withFilter(TriggerFilter filter){
            _visitables.get("filter").remove(this.filter);
            if (filter!=null){ this.filter= new TriggerFilterBuilder(filter); _visitables.get("filter").add(this.filter);} return (A) this;
    }

    public Boolean hasFilter(){
            return this.filter != null;
    }

    public TriggerSpecFluent.FilterNested<A> withNewFilter(){
            return new FilterNestedImpl();
    }

    public TriggerSpecFluent.FilterNested<A> withNewFilterLike(TriggerFilter item){
            return new FilterNestedImpl(item);
    }

    public TriggerSpecFluent.FilterNested<A> editFilter(){
            return withNewFilterLike(getFilter());
    }

    public TriggerSpecFluent.FilterNested<A> editOrNewFilter(){
            return withNewFilterLike(getFilter() != null ? getFilter(): new TriggerFilterBuilder().build());
    }

    public TriggerSpecFluent.FilterNested<A> editOrNewFilterLike(TriggerFilter item){
            return withNewFilterLike(getFilter() != null ? getFilter(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscriber instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec getSubscriber(){
            return this.subscriber!=null?this.subscriber.build():null;
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildSubscriber(){
            return this.subscriber!=null?this.subscriber.build():null;
    }

    public A withSubscriber(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec subscriber){
            _visitables.get("subscriber").remove(this.subscriber);
            if (subscriber!=null){ this.subscriber= new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} return (A) this;
    }

    public Boolean hasSubscriber(){
            return this.subscriber != null;
    }

    public TriggerSpecFluent.SubscriberNested<A> withNewSubscriber(){
            return new SubscriberNestedImpl();
    }

    public TriggerSpecFluent.SubscriberNested<A> withNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return new SubscriberNestedImpl(item);
    }

    public TriggerSpecFluent.SubscriberNested<A> editSubscriber(){
            return withNewSubscriberLike(getSubscriber());
    }

    public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriber(){
            return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder().build());
    }

    public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerSpecFluentImpl that = (TriggerSpecFluentImpl) o;
            if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
            if (filter != null ? !filter.equals(that.filter) :that.filter != null) return false;
            if (subscriber != null ? !subscriber.equals(that.subscriber) :that.subscriber != null) return false;
            return true;
    }


    public class FilterNestedImpl<N> extends TriggerFilterFluentImpl<TriggerSpecFluent.FilterNested<N>> implements TriggerSpecFluent.FilterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerFilterBuilder builder;
    
            FilterNestedImpl(TriggerFilter item){
                    this.builder = new TriggerFilterBuilder(this, item);
            }
            FilterNestedImpl(){
                    this.builder = new TriggerFilterBuilder(this);
            }
    
    public N and(){
            return (N) TriggerSpecFluentImpl.this.withFilter(builder.build());
    }
    public N endFilter(){
            return and();
    }

}
    public class SubscriberNestedImpl<N> extends io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluentImpl<TriggerSpecFluent.SubscriberNested<N>> implements TriggerSpecFluent.SubscriberNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder;
    
            SubscriberNestedImpl(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this, item);
            }
            SubscriberNestedImpl(){
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this);
            }
    
    public N and(){
            return (N) TriggerSpecFluentImpl.this.withSubscriber(builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
