package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SequenceStatusBuilder extends SequenceStatusFluentImpl<SequenceStatusBuilder> implements VisitableBuilder<SequenceStatus,SequenceStatusBuilder>{

    SequenceStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SequenceStatusBuilder(){
            this(true);
    }
    public SequenceStatusBuilder(Boolean validationEnabled){
            this(new SequenceStatus(), validationEnabled);
    }
    public SequenceStatusBuilder(SequenceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SequenceStatus(), validationEnabled);
    }
    public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance){
            this(fluent, instance, true);
    }
    public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withChannelStatuses(instance.getChannelStatuses()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
            this.validationEnabled = validationEnabled; 
    }
    public SequenceStatusBuilder(SequenceStatus instance){
            this(instance,true);
    }
    public SequenceStatusBuilder(SequenceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withChannelStatuses(instance.getChannelStatuses()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
            this.validationEnabled = validationEnabled; 
    }
    public SequenceStatusBuilder(Validator validator){
            this(new SequenceStatus(), true);
    }
    public SequenceStatusBuilder(SequenceStatusFluent<?> fluent,SequenceStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withChannelStatuses(instance.getChannelStatuses()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SequenceStatusBuilder(SequenceStatus instance,Validator validator){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withChannelStatuses(instance.getChannelStatuses()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscriptionStatuses(instance.getSubscriptionStatuses()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SequenceStatus build(){
            SequenceStatus buildable = new SequenceStatus(fluent.getAddress(),fluent.getChannelStatuses(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSubscriptionStatuses());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SequenceStatusBuilder that = (SequenceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
