package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BrokerBuilder extends BrokerFluentImpl<BrokerBuilder> implements VisitableBuilder<Broker,BrokerBuilder>{

    BrokerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BrokerBuilder(){
            this(true);
    }
    public BrokerBuilder(Boolean validationEnabled){
            this(new Broker(), validationEnabled);
    }
    public BrokerBuilder(BrokerFluent<?> fluent){
            this(fluent, true);
    }
    public BrokerBuilder(BrokerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Broker(), validationEnabled);
    }
    public BrokerBuilder(BrokerFluent<?> fluent,Broker instance){
            this(fluent, instance, true);
    }
    public BrokerBuilder(BrokerFluent<?> fluent,Broker instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerBuilder(Broker instance){
            this(instance,true);
    }
    public BrokerBuilder(Broker instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerBuilder(Validator validator){
            this(new Broker(), true);
    }
    public BrokerBuilder(BrokerFluent<?> fluent,Broker instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BrokerBuilder(Broker instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Broker build(){
            Broker buildable = new Broker(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BrokerBuilder that = (BrokerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
