package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubscriptionListBuilder extends SubscriptionListFluentImpl<SubscriptionListBuilder> implements VisitableBuilder<SubscriptionList,SubscriptionListBuilder>{

    SubscriptionListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubscriptionListBuilder(){
            this(true);
    }
    public SubscriptionListBuilder(Boolean validationEnabled){
            this(new SubscriptionList(), validationEnabled);
    }
    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriptionList(), validationEnabled);
    }
    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance){
            this(fluent, instance, true);
    }
    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionListBuilder(SubscriptionList instance){
            this(instance,true);
    }
    public SubscriptionListBuilder(SubscriptionList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionListBuilder(Validator validator){
            this(new SubscriptionList(), true);
    }
    public SubscriptionListBuilder(SubscriptionListFluent<?> fluent,SubscriptionList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubscriptionListBuilder(SubscriptionList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubscriptionList build(){
            SubscriptionList buildable = new SubscriptionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionListBuilder that = (SubscriptionListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
