package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubscriptionStatusPhysicalSubscriptionBuilder extends SubscriptionStatusPhysicalSubscriptionFluentImpl<SubscriptionStatusPhysicalSubscriptionBuilder> implements VisitableBuilder<SubscriptionStatusPhysicalSubscription,SubscriptionStatusPhysicalSubscriptionBuilder>{

    SubscriptionStatusPhysicalSubscriptionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubscriptionStatusPhysicalSubscriptionBuilder(){
            this(true);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(Boolean validationEnabled){
            this(new SubscriptionStatusPhysicalSubscription(), validationEnabled);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriptionStatusPhysicalSubscription(), validationEnabled);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,SubscriptionStatusPhysicalSubscription instance){
            this(fluent, instance, true);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,SubscriptionStatusPhysicalSubscription instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplyURI(instance.getReplyURI()); 
            fluent.withSubscriberURI(instance.getSubscriberURI()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscription instance){
            this(instance,true);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscription instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplyURI(instance.getReplyURI()); 
            this.withSubscriberURI(instance.getSubscriberURI()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(Validator validator){
            this(new SubscriptionStatusPhysicalSubscription(), true);
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscriptionFluent<?> fluent,SubscriptionStatusPhysicalSubscription instance,Validator validator){
            this.fluent = fluent; 
            fluent.withReplyURI(instance.getReplyURI()); 
            fluent.withSubscriberURI(instance.getSubscriberURI()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubscriptionStatusPhysicalSubscriptionBuilder(SubscriptionStatusPhysicalSubscription instance,Validator validator){
            this.fluent = this; 
            this.withReplyURI(instance.getReplyURI()); 
            this.withSubscriberURI(instance.getSubscriberURI()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubscriptionStatusPhysicalSubscription build(){
            SubscriptionStatusPhysicalSubscription buildable = new SubscriptionStatusPhysicalSubscription(fluent.getReplyURI(),fluent.getSubscriberURI());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionStatusPhysicalSubscriptionBuilder that = (SubscriptionStatusPhysicalSubscriptionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
