package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface TriggerFluent<A extends TriggerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public TriggerFluent.MetadataNested<A> withNewMetadata();
    public TriggerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public TriggerFluent.MetadataNested<A> editMetadata();
    public TriggerFluent.MetadataNested<A> editOrNewMetadata();
    public TriggerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public TriggerSpec getSpec();
    public TriggerSpec buildSpec();
    public A withSpec(TriggerSpec spec);
    public Boolean hasSpec();
    public TriggerFluent.SpecNested<A> withNewSpec();
    public TriggerFluent.SpecNested<A> withNewSpecLike(TriggerSpec item);
    public TriggerFluent.SpecNested<A> editSpec();
    public TriggerFluent.SpecNested<A> editOrNewSpec();
    public TriggerFluent.SpecNested<A> editOrNewSpecLike(TriggerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public TriggerStatus getStatus();
    public TriggerStatus buildStatus();
    public A withStatus(TriggerStatus status);
    public Boolean hasStatus();
    public TriggerFluent.StatusNested<A> withNewStatus();
    public TriggerFluent.StatusNested<A> withNewStatusLike(TriggerStatus item);
    public TriggerFluent.StatusNested<A> editStatus();
    public TriggerFluent.StatusNested<A> editOrNewStatus();
    public TriggerFluent.StatusNested<A> editOrNewStatusLike(TriggerStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<TriggerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerSpecFluent<TriggerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TriggerStatusFluent<TriggerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
