package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SequenceBuilder extends SequenceFluentImpl<SequenceBuilder> implements VisitableBuilder<Sequence,SequenceBuilder>{

    SequenceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SequenceBuilder(){
            this(true);
    }
    public SequenceBuilder(Boolean validationEnabled){
            this(new Sequence(), validationEnabled);
    }
    public SequenceBuilder(SequenceFluent<?> fluent){
            this(fluent, true);
    }
    public SequenceBuilder(SequenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Sequence(), validationEnabled);
    }
    public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance){
            this(fluent, instance, true);
    }
    public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SequenceBuilder(Sequence instance){
            this(instance,true);
    }
    public SequenceBuilder(Sequence instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SequenceBuilder(Validator validator){
            this(new Sequence(), true);
    }
    public SequenceBuilder(SequenceFluent<?> fluent,Sequence instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SequenceBuilder(Sequence instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Sequence build(){
            Sequence buildable = new Sequence(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SequenceBuilder that = (SequenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
