package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ConfigurationListBuilder extends ConfigurationListFluentImpl<ConfigurationListBuilder> implements VisitableBuilder<ConfigurationList,ConfigurationListBuilder>{

    ConfigurationListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ConfigurationListBuilder(){
            this(true);
    }
    public ConfigurationListBuilder(Boolean validationEnabled){
            this(new ConfigurationList(), validationEnabled);
    }
    public ConfigurationListBuilder(ConfigurationListFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConfigurationList(), validationEnabled);
    }
    public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance){
            this(fluent, instance, true);
    }
    public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationListBuilder(ConfigurationList instance){
            this(instance,true);
    }
    public ConfigurationListBuilder(ConfigurationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationListBuilder(Validator validator){
            this(new ConfigurationList(), true);
    }
    public ConfigurationListBuilder(ConfigurationListFluent<?> fluent,ConfigurationList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ConfigurationListBuilder(ConfigurationList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ConfigurationList build(){
            ConfigurationList buildable = new ConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigurationListBuilder that = (ConfigurationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
