package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubscriberStatusBuilder extends SubscriberStatusFluentImpl<SubscriberStatusBuilder> implements VisitableBuilder<SubscriberStatus,SubscriberStatusBuilder>{

    SubscriberStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubscriberStatusBuilder(){
            this(true);
    }
    public SubscriberStatusBuilder(Boolean validationEnabled){
            this(new SubscriberStatus(), validationEnabled);
    }
    public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriberStatus(), validationEnabled);
    }
    public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,SubscriberStatus instance){
            this(fluent, instance, true);
    }
    public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,SubscriberStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReady(instance.getReady()); 
            fluent.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriberStatusBuilder(SubscriberStatus instance){
            this(instance,true);
    }
    public SubscriberStatusBuilder(SubscriberStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReady(instance.getReady()); 
            this.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriberStatusBuilder(Validator validator){
            this(new SubscriberStatus(), true);
    }
    public SubscriberStatusBuilder(SubscriberStatusFluent<?> fluent,SubscriberStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReady(instance.getReady()); 
            fluent.withUid(instance.getUid()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubscriberStatusBuilder(SubscriberStatus instance,Validator validator){
            this.fluent = this; 
            this.withMessage(instance.getMessage()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReady(instance.getReady()); 
            this.withUid(instance.getUid()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubscriberStatus build(){
            SubscriberStatus buildable = new SubscriberStatus(fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReady(),fluent.getUid());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriberStatusBuilder that = (SubscriberStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
