package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterChannelProvisionerListBuilder extends ClusterChannelProvisionerListFluentImpl<ClusterChannelProvisionerListBuilder> implements VisitableBuilder<ClusterChannelProvisionerList,ClusterChannelProvisionerListBuilder>{

    ClusterChannelProvisionerListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterChannelProvisionerListBuilder(){
            this(true);
    }
    public ClusterChannelProvisionerListBuilder(Boolean validationEnabled){
            this(new ClusterChannelProvisionerList(), validationEnabled);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerListFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterChannelProvisionerList(), validationEnabled);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerListFluent<?> fluent,ClusterChannelProvisionerList instance){
            this(fluent, instance, true);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerListFluent<?> fluent,ClusterChannelProvisionerList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerList instance){
            this(instance,true);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerListBuilder(Validator validator){
            this(new ClusterChannelProvisionerList(), true);
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerListFluent<?> fluent,ClusterChannelProvisionerList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterChannelProvisionerListBuilder(ClusterChannelProvisionerList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterChannelProvisionerList build(){
            ClusterChannelProvisionerList buildable = new ClusterChannelProvisionerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterChannelProvisionerListBuilder that = (ClusterChannelProvisionerListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
