package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RevisionSpecBuilder extends RevisionSpecFluentImpl<RevisionSpecBuilder> implements VisitableBuilder<RevisionSpec,RevisionSpecBuilder>{

    RevisionSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RevisionSpecBuilder(){
            this(true);
    }
    public RevisionSpecBuilder(Boolean validationEnabled){
            this(new RevisionSpec(), validationEnabled);
    }
    public RevisionSpecBuilder(RevisionSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RevisionSpec(), validationEnabled);
    }
    public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,RevisionSpec instance){
            this(fluent, instance, true);
    }
    public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,RevisionSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainerConcurrency(instance.getContainerConcurrency()); 
            fluent.withContainers(instance.getContainers()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public RevisionSpecBuilder(RevisionSpec instance){
            this(instance,true);
    }
    public RevisionSpecBuilder(RevisionSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainerConcurrency(instance.getContainerConcurrency()); 
            this.withContainers(instance.getContainers()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.withVolumes(instance.getVolumes()); 
            this.validationEnabled = validationEnabled; 
    }
    public RevisionSpecBuilder(Validator validator){
            this(new RevisionSpec(), true);
    }
    public RevisionSpecBuilder(RevisionSpecFluent<?> fluent,RevisionSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withContainerConcurrency(instance.getContainerConcurrency()); 
            fluent.withContainers(instance.getContainers()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            fluent.withVolumes(instance.getVolumes()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RevisionSpecBuilder(RevisionSpec instance,Validator validator){
            this.fluent = this; 
            this.withContainerConcurrency(instance.getContainerConcurrency()); 
            this.withContainers(instance.getContainers()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.withVolumes(instance.getVolumes()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RevisionSpec build(){
            RevisionSpec buildable = new RevisionSpec(fluent.getContainerConcurrency(),fluent.getContainers(),fluent.getServiceAccountName(),fluent.getTimeoutSeconds(),fluent.getVolumes());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RevisionSpecBuilder that = (RevisionSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
