package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceSpecFluent<A>{

    private RevisionTemplateSpecBuilder template;
    private List<TrafficTargetBuilder> traffic;

    public ServiceSpecFluentImpl(){
    }
    public ServiceSpecFluentImpl(ServiceSpec instance){
            this.withTemplate(instance.getTemplate()); 
            this.withTraffic(instance.getTraffic()); 
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public RevisionTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public RevisionTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(RevisionTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new RevisionTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public ServiceSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public ServiceSpecFluent.TemplateNested<A> withNewTemplateLike(RevisionTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public ServiceSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new RevisionTemplateSpecBuilder().build());
    }

    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplateLike(RevisionTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public A addToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
            if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
             return (A)this;
    }

    public A addToTraffic(TrafficTarget... items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<TrafficTarget> items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(TrafficTarget... items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@Deprecated public List<TrafficTarget> getTraffic(){
            return build(traffic);
    }

    public List<TrafficTarget> buildTraffic(){
            return build(traffic);
    }

    public TrafficTarget buildTraffic(int index){
            return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic(){
            return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic(){
            return this.traffic.get(traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTraffic(List<TrafficTarget> traffic){
            if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
            if (traffic != null) {this.traffic = new ArrayList<TrafficTargetBuilder>(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = new ArrayList<TrafficTargetBuilder>();} return (A) this;
    }

    public A withTraffic(TrafficTarget... traffic){
            if (this.traffic != null) {this.traffic.clear();}
            if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public Boolean hasTraffic(){
            return traffic != null && !traffic.isEmpty();
    }

    public ServiceSpecFluent.TrafficNested<A> addNewTraffic(){
            return new TrafficNestedImpl();
    }

    public ServiceSpecFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item){
            return new TrafficNestedImpl(-1, item);
    }

    public ServiceSpecFluent.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item){
            return new TrafficNestedImpl(index, item);
    }

    public ServiceSpecFluent.TrafficNested<A> editTraffic(int index){
            if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceSpecFluent.TrafficNested<A> editFirstTraffic(){
            if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
            return setNewTrafficLike(0, buildTraffic(0));
    }

    public ServiceSpecFluent.TrafficNested<A> editLastTraffic(){
            int index = traffic.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceSpecFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            int index = -1;
            for (int i=0;i<traffic.size();i++) { 
            if (predicate.apply(traffic.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
            return true;
    }


    public class TemplateNestedImpl<N> extends RevisionTemplateSpecFluentImpl<ServiceSpecFluent.TemplateNested<N>> implements ServiceSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RevisionTemplateSpecBuilder builder;
    
            TemplateNestedImpl(RevisionTemplateSpec item){
                    this.builder = new RevisionTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new RevisionTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<ServiceSpecFluent.TrafficNested<N>> implements ServiceSpecFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TrafficTargetBuilder builder;
        private final int index;
    
            TrafficNestedImpl(int index,TrafficTarget item){
                    this.index = index;
                    this.builder = new TrafficTargetBuilder(this, item);
            }
            TrafficNestedImpl(){
                    this.index = -1;
                    this.builder = new TrafficTargetBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.setToTraffic(index, builder.build());
    }
    public N endTraffic(){
            return and();
    }

}


}
