package io.fabric8.knative.api.model;

import io.fabric8.knative.serving.v1beta1.ConfigurationBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.serving.v1beta1.Configuration;
import io.fabric8.knative.serving.v1beta1.RevisionList;
import io.fabric8.knative.eventing.v1alpha1.TriggerListBuilder;
import io.fabric8.knative.serving.v1beta1.RouteList;
import io.fabric8.knative.eventing.v1alpha1.EventTypeList;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.eventing.v1alpha1.EventTypeListFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.Subscription;
import java.lang.Boolean;
import io.fabric8.knative.serving.v1beta1.ConfigurationFluentImpl;
import io.fabric8.knative.serving.v1beta1.RevisionListFluentImpl;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelListFluentImpl;
import io.fabric8.knative.serving.v1beta1.RevisionFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.SubscriptionBuilder;
import io.fabric8.knative.eventing.v1alpha1.BrokerFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.TriggerBuilder;
import io.fabric8.knative.serving.v1beta1.RouteListFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.TriggerListFluentImpl;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelList;
import java.lang.Object;
import io.fabric8.knative.eventing.v1alpha1.BrokerList;
import io.fabric8.knative.serving.v1beta1.ConfigurationListBuilder;
import io.fabric8.knative.serving.v1beta1.RouteListBuilder;
import io.fabric8.knative.serving.v1beta1.RouteBuilder;
import io.fabric8.knative.eventing.v1alpha1.ChannelListFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.BrokerListBuilder;
import io.fabric8.knative.eventing.v1alpha1.ChannelListBuilder;
import java.lang.Deprecated;
import io.fabric8.knative.serving.v1beta1.ConfigurationList;
import io.fabric8.knative.eventing.v1alpha1.ChannelBuilder;
import io.fabric8.knative.eventing.v1alpha1.SubscriptionListFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.SubscriptionFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.BrokerBuilder;
import io.fabric8.knative.eventing.v1alpha1.EventTypeBuilder;
import io.fabric8.knative.eventing.v1alpha1.EventTypeListBuilder;
import io.fabric8.knative.eventing.v1alpha1.TriggerFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ChannelFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisionerListBuilder;
import io.fabric8.knative.serving.v1beta1.RevisionBuilder;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelListBuilder;
import io.fabric8.knative.eventing.v1alpha1.SubscriptionList;
import io.fabric8.knative.eventing.v1alpha1.EventType;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisionerList;
import io.fabric8.knative.eventing.v1alpha1.EventTypeFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisionerFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.Trigger;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisionerListFluentImpl;
import io.fabric8.knative.serving.v1beta1.RevisionListBuilder;
import io.fabric8.knative.eventing.v1alpha1.TriggerList;
import io.fabric8.knative.eventing.v1alpha1.ChannelList;
import io.fabric8.knative.serving.v1beta1.Route;
import io.fabric8.knative.serving.v1beta1.RouteFluentImpl;
import io.fabric8.knative.serving.v1beta1.ServiceListBuilder;
import io.fabric8.knative.messaging.v1alpha1.SequenceListFluentImpl;
import io.fabric8.knative.serving.v1beta1.ServiceList;
import io.fabric8.knative.eventing.v1alpha1.Channel;
import io.fabric8.knative.serving.v1beta1.ServiceListFluentImpl;
import io.fabric8.knative.messaging.v1alpha1.Sequence;
import io.fabric8.knative.messaging.v1alpha1.SequenceListBuilder;
import io.fabric8.knative.serving.v1beta1.ConfigurationListFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisioner;
import io.fabric8.knative.serving.v1beta1.Revision;
import io.fabric8.knative.eventing.v1alpha1.SubscriptionListBuilder;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannel;
import io.fabric8.knative.messaging.v1alpha1.SequenceFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.ClusterChannelProvisionerBuilder;
import io.fabric8.knative.messaging.v1alpha1.SequenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelBuilder;
import io.fabric8.knative.serving.v1beta1.ServiceBuilder;
import io.fabric8.knative.eventing.v1alpha1.Broker;
import io.fabric8.knative.serving.v1beta1.Service;
import io.fabric8.knative.messaging.v1alpha1.SequenceList;
import io.fabric8.knative.serving.v1beta1.ServiceFluentImpl;
import io.fabric8.knative.eventing.v1alpha1.BrokerListFluentImpl;

public class KnativeSchemaFluentImpl<A extends KnativeSchemaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KnativeSchemaFluent<A>{

    private BrokerBuilder broker;
    private BrokerListBuilder brokerList;
    private ChannelBuilder channel;
    private ChannelListBuilder channelList;
    private ClusterChannelProvisionerBuilder clusterChannelProvisioner;
    private ClusterChannelProvisionerListBuilder clusterChannelProvisionerList;
    private ConfigurationBuilder configuration;
    private ConfigurationListBuilder configurationList;
    private EventTypeBuilder eventType;
    private EventTypeListBuilder eventTypeList;
    private InMemoryChannelBuilder inMemoryChannel;
    private InMemoryChannelListBuilder inMemoryChannelList;
    private RevisionBuilder revision;
    private RevisionListBuilder revisionList;
    private RouteBuilder route;
    private RouteListBuilder routeList;
    private SequenceBuilder sequence;
    private SequenceListBuilder sequenceList;
    private ServiceBuilder service;
    private ServiceListBuilder serviceList;
    private SubscriptionBuilder subscription;
    private SubscriptionListBuilder subscriptionList;
    private TriggerBuilder trigger;
    private TriggerListBuilder triggerList;

    public KnativeSchemaFluentImpl(){
    }
    public KnativeSchemaFluentImpl(KnativeSchema instance){
            this.withBroker(instance.getBroker()); 
            this.withBrokerList(instance.getBrokerList()); 
            this.withChannel(instance.getChannel()); 
            this.withChannelList(instance.getChannelList()); 
            this.withClusterChannelProvisioner(instance.getClusterChannelProvisioner()); 
            this.withClusterChannelProvisionerList(instance.getClusterChannelProvisionerList()); 
            this.withConfiguration(instance.getConfiguration()); 
            this.withConfigurationList(instance.getConfigurationList()); 
            this.withEventType(instance.getEventType()); 
            this.withEventTypeList(instance.getEventTypeList()); 
            this.withInMemoryChannel(instance.getInMemoryChannel()); 
            this.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            this.withRevision(instance.getRevision()); 
            this.withRevisionList(instance.getRevisionList()); 
            this.withRoute(instance.getRoute()); 
            this.withRouteList(instance.getRouteList()); 
            this.withSequence(instance.getSequence()); 
            this.withSequenceList(instance.getSequenceList()); 
            this.withService(instance.getService()); 
            this.withServiceList(instance.getServiceList()); 
            this.withSubscription(instance.getSubscription()); 
            this.withSubscriptionList(instance.getSubscriptionList()); 
            this.withTrigger(instance.getTrigger()); 
            this.withTriggerList(instance.getTriggerList()); 
    }

    
/**
 * This method has been deprecated, please use method buildBroker instead.
 * @return The buildable object.
 */
@Deprecated public Broker getBroker(){
            return this.broker!=null?this.broker.build():null;
    }

    public Broker buildBroker(){
            return this.broker!=null?this.broker.build():null;
    }

    public A withBroker(Broker broker){
            _visitables.get("broker").remove(this.broker);
            if (broker!=null){ this.broker= new BrokerBuilder(broker); _visitables.get("broker").add(this.broker);} return (A) this;
    }

    public Boolean hasBroker(){
            return this.broker != null;
    }

    public KnativeSchemaFluent.BrokerNested<A> withNewBroker(){
            return new BrokerNestedImpl();
    }

    public KnativeSchemaFluent.BrokerNested<A> withNewBrokerLike(Broker item){
            return new BrokerNestedImpl(item);
    }

    public KnativeSchemaFluent.BrokerNested<A> editBroker(){
            return withNewBrokerLike(getBroker());
    }

    public KnativeSchemaFluent.BrokerNested<A> editOrNewBroker(){
            return withNewBrokerLike(getBroker() != null ? getBroker(): new BrokerBuilder().build());
    }

    public KnativeSchemaFluent.BrokerNested<A> editOrNewBrokerLike(Broker item){
            return withNewBrokerLike(getBroker() != null ? getBroker(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBrokerList instead.
 * @return The buildable object.
 */
@Deprecated public BrokerList getBrokerList(){
            return this.brokerList!=null?this.brokerList.build():null;
    }

    public BrokerList buildBrokerList(){
            return this.brokerList!=null?this.brokerList.build():null;
    }

    public A withBrokerList(BrokerList brokerList){
            _visitables.get("brokerList").remove(this.brokerList);
            if (brokerList!=null){ this.brokerList= new BrokerListBuilder(brokerList); _visitables.get("brokerList").add(this.brokerList);} return (A) this;
    }

    public Boolean hasBrokerList(){
            return this.brokerList != null;
    }

    public KnativeSchemaFluent.BrokerListNested<A> withNewBrokerList(){
            return new BrokerListNestedImpl();
    }

    public KnativeSchemaFluent.BrokerListNested<A> withNewBrokerListLike(BrokerList item){
            return new BrokerListNestedImpl(item);
    }

    public KnativeSchemaFluent.BrokerListNested<A> editBrokerList(){
            return withNewBrokerListLike(getBrokerList());
    }

    public KnativeSchemaFluent.BrokerListNested<A> editOrNewBrokerList(){
            return withNewBrokerListLike(getBrokerList() != null ? getBrokerList(): new BrokerListBuilder().build());
    }

    public KnativeSchemaFluent.BrokerListNested<A> editOrNewBrokerListLike(BrokerList item){
            return withNewBrokerListLike(getBrokerList() != null ? getBrokerList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildChannel instead.
 * @return The buildable object.
 */
@Deprecated public Channel getChannel(){
            return this.channel!=null?this.channel.build():null;
    }

    public Channel buildChannel(){
            return this.channel!=null?this.channel.build():null;
    }

    public A withChannel(Channel channel){
            _visitables.get("channel").remove(this.channel);
            if (channel!=null){ this.channel= new ChannelBuilder(channel); _visitables.get("channel").add(this.channel);} return (A) this;
    }

    public Boolean hasChannel(){
            return this.channel != null;
    }

    public KnativeSchemaFluent.ChannelNested<A> withNewChannel(){
            return new ChannelNestedImpl();
    }

    public KnativeSchemaFluent.ChannelNested<A> withNewChannelLike(Channel item){
            return new ChannelNestedImpl(item);
    }

    public KnativeSchemaFluent.ChannelNested<A> editChannel(){
            return withNewChannelLike(getChannel());
    }

    public KnativeSchemaFluent.ChannelNested<A> editOrNewChannel(){
            return withNewChannelLike(getChannel() != null ? getChannel(): new ChannelBuilder().build());
    }

    public KnativeSchemaFluent.ChannelNested<A> editOrNewChannelLike(Channel item){
            return withNewChannelLike(getChannel() != null ? getChannel(): item);
    }

    
/**
 * This method has been deprecated, please use method buildChannelList instead.
 * @return The buildable object.
 */
@Deprecated public ChannelList getChannelList(){
            return this.channelList!=null?this.channelList.build():null;
    }

    public ChannelList buildChannelList(){
            return this.channelList!=null?this.channelList.build():null;
    }

    public A withChannelList(ChannelList channelList){
            _visitables.get("channelList").remove(this.channelList);
            if (channelList!=null){ this.channelList= new ChannelListBuilder(channelList); _visitables.get("channelList").add(this.channelList);} return (A) this;
    }

    public Boolean hasChannelList(){
            return this.channelList != null;
    }

    public KnativeSchemaFluent.ChannelListNested<A> withNewChannelList(){
            return new ChannelListNestedImpl();
    }

    public KnativeSchemaFluent.ChannelListNested<A> withNewChannelListLike(ChannelList item){
            return new ChannelListNestedImpl(item);
    }

    public KnativeSchemaFluent.ChannelListNested<A> editChannelList(){
            return withNewChannelListLike(getChannelList());
    }

    public KnativeSchemaFluent.ChannelListNested<A> editOrNewChannelList(){
            return withNewChannelListLike(getChannelList() != null ? getChannelList(): new ChannelListBuilder().build());
    }

    public KnativeSchemaFluent.ChannelListNested<A> editOrNewChannelListLike(ChannelList item){
            return withNewChannelListLike(getChannelList() != null ? getChannelList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClusterChannelProvisioner instead.
 * @return The buildable object.
 */
@Deprecated public ClusterChannelProvisioner getClusterChannelProvisioner(){
            return this.clusterChannelProvisioner!=null?this.clusterChannelProvisioner.build():null;
    }

    public ClusterChannelProvisioner buildClusterChannelProvisioner(){
            return this.clusterChannelProvisioner!=null?this.clusterChannelProvisioner.build():null;
    }

    public A withClusterChannelProvisioner(ClusterChannelProvisioner clusterChannelProvisioner){
            _visitables.get("clusterChannelProvisioner").remove(this.clusterChannelProvisioner);
            if (clusterChannelProvisioner!=null){ this.clusterChannelProvisioner= new ClusterChannelProvisionerBuilder(clusterChannelProvisioner); _visitables.get("clusterChannelProvisioner").add(this.clusterChannelProvisioner);} return (A) this;
    }

    public Boolean hasClusterChannelProvisioner(){
            return this.clusterChannelProvisioner != null;
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerNested<A> withNewClusterChannelProvisioner(){
            return new ClusterChannelProvisionerNestedImpl();
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerNested<A> withNewClusterChannelProvisionerLike(ClusterChannelProvisioner item){
            return new ClusterChannelProvisionerNestedImpl(item);
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerNested<A> editClusterChannelProvisioner(){
            return withNewClusterChannelProvisionerLike(getClusterChannelProvisioner());
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerNested<A> editOrNewClusterChannelProvisioner(){
            return withNewClusterChannelProvisionerLike(getClusterChannelProvisioner() != null ? getClusterChannelProvisioner(): new ClusterChannelProvisionerBuilder().build());
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerNested<A> editOrNewClusterChannelProvisionerLike(ClusterChannelProvisioner item){
            return withNewClusterChannelProvisionerLike(getClusterChannelProvisioner() != null ? getClusterChannelProvisioner(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClusterChannelProvisionerList instead.
 * @return The buildable object.
 */
@Deprecated public ClusterChannelProvisionerList getClusterChannelProvisionerList(){
            return this.clusterChannelProvisionerList!=null?this.clusterChannelProvisionerList.build():null;
    }

    public ClusterChannelProvisionerList buildClusterChannelProvisionerList(){
            return this.clusterChannelProvisionerList!=null?this.clusterChannelProvisionerList.build():null;
    }

    public A withClusterChannelProvisionerList(ClusterChannelProvisionerList clusterChannelProvisionerList){
            _visitables.get("clusterChannelProvisionerList").remove(this.clusterChannelProvisionerList);
            if (clusterChannelProvisionerList!=null){ this.clusterChannelProvisionerList= new ClusterChannelProvisionerListBuilder(clusterChannelProvisionerList); _visitables.get("clusterChannelProvisionerList").add(this.clusterChannelProvisionerList);} return (A) this;
    }

    public Boolean hasClusterChannelProvisionerList(){
            return this.clusterChannelProvisionerList != null;
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerListNested<A> withNewClusterChannelProvisionerList(){
            return new ClusterChannelProvisionerListNestedImpl();
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerListNested<A> withNewClusterChannelProvisionerListLike(ClusterChannelProvisionerList item){
            return new ClusterChannelProvisionerListNestedImpl(item);
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerListNested<A> editClusterChannelProvisionerList(){
            return withNewClusterChannelProvisionerListLike(getClusterChannelProvisionerList());
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerListNested<A> editOrNewClusterChannelProvisionerList(){
            return withNewClusterChannelProvisionerListLike(getClusterChannelProvisionerList() != null ? getClusterChannelProvisionerList(): new ClusterChannelProvisionerListBuilder().build());
    }

    public KnativeSchemaFluent.ClusterChannelProvisionerListNested<A> editOrNewClusterChannelProvisionerListLike(ClusterChannelProvisionerList item){
            return withNewClusterChannelProvisionerListLike(getClusterChannelProvisionerList() != null ? getClusterChannelProvisionerList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public Configuration getConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public Configuration buildConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(Configuration configuration){
            _visitables.get("configuration").remove(this.configuration);
            if (configuration!=null){ this.configuration= new ConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration(){
            return this.configuration != null;
    }

    public KnativeSchemaFluent.ConfigurationNested<A> withNewConfiguration(){
            return new ConfigurationNestedImpl();
    }

    public KnativeSchemaFluent.ConfigurationNested<A> withNewConfigurationLike(Configuration item){
            return new ConfigurationNestedImpl(item);
    }

    public KnativeSchemaFluent.ConfigurationNested<A> editConfiguration(){
            return withNewConfigurationLike(getConfiguration());
    }

    public KnativeSchemaFluent.ConfigurationNested<A> editOrNewConfiguration(){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new ConfigurationBuilder().build());
    }

    public KnativeSchemaFluent.ConfigurationNested<A> editOrNewConfigurationLike(Configuration item){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConfigurationList instead.
 * @return The buildable object.
 */
@Deprecated public ConfigurationList getConfigurationList(){
            return this.configurationList!=null?this.configurationList.build():null;
    }

    public ConfigurationList buildConfigurationList(){
            return this.configurationList!=null?this.configurationList.build():null;
    }

    public A withConfigurationList(ConfigurationList configurationList){
            _visitables.get("configurationList").remove(this.configurationList);
            if (configurationList!=null){ this.configurationList= new ConfigurationListBuilder(configurationList); _visitables.get("configurationList").add(this.configurationList);} return (A) this;
    }

    public Boolean hasConfigurationList(){
            return this.configurationList != null;
    }

    public KnativeSchemaFluent.ConfigurationListNested<A> withNewConfigurationList(){
            return new ConfigurationListNestedImpl();
    }

    public KnativeSchemaFluent.ConfigurationListNested<A> withNewConfigurationListLike(ConfigurationList item){
            return new ConfigurationListNestedImpl(item);
    }

    public KnativeSchemaFluent.ConfigurationListNested<A> editConfigurationList(){
            return withNewConfigurationListLike(getConfigurationList());
    }

    public KnativeSchemaFluent.ConfigurationListNested<A> editOrNewConfigurationList(){
            return withNewConfigurationListLike(getConfigurationList() != null ? getConfigurationList(): new ConfigurationListBuilder().build());
    }

    public KnativeSchemaFluent.ConfigurationListNested<A> editOrNewConfigurationListLike(ConfigurationList item){
            return withNewConfigurationListLike(getConfigurationList() != null ? getConfigurationList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEventType instead.
 * @return The buildable object.
 */
@Deprecated public EventType getEventType(){
            return this.eventType!=null?this.eventType.build():null;
    }

    public EventType buildEventType(){
            return this.eventType!=null?this.eventType.build():null;
    }

    public A withEventType(EventType eventType){
            _visitables.get("eventType").remove(this.eventType);
            if (eventType!=null){ this.eventType= new EventTypeBuilder(eventType); _visitables.get("eventType").add(this.eventType);} return (A) this;
    }

    public Boolean hasEventType(){
            return this.eventType != null;
    }

    public KnativeSchemaFluent.EventTypeNested<A> withNewEventType(){
            return new EventTypeNestedImpl();
    }

    public KnativeSchemaFluent.EventTypeNested<A> withNewEventTypeLike(EventType item){
            return new EventTypeNestedImpl(item);
    }

    public KnativeSchemaFluent.EventTypeNested<A> editEventType(){
            return withNewEventTypeLike(getEventType());
    }

    public KnativeSchemaFluent.EventTypeNested<A> editOrNewEventType(){
            return withNewEventTypeLike(getEventType() != null ? getEventType(): new EventTypeBuilder().build());
    }

    public KnativeSchemaFluent.EventTypeNested<A> editOrNewEventTypeLike(EventType item){
            return withNewEventTypeLike(getEventType() != null ? getEventType(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEventTypeList instead.
 * @return The buildable object.
 */
@Deprecated public EventTypeList getEventTypeList(){
            return this.eventTypeList!=null?this.eventTypeList.build():null;
    }

    public EventTypeList buildEventTypeList(){
            return this.eventTypeList!=null?this.eventTypeList.build():null;
    }

    public A withEventTypeList(EventTypeList eventTypeList){
            _visitables.get("eventTypeList").remove(this.eventTypeList);
            if (eventTypeList!=null){ this.eventTypeList= new EventTypeListBuilder(eventTypeList); _visitables.get("eventTypeList").add(this.eventTypeList);} return (A) this;
    }

    public Boolean hasEventTypeList(){
            return this.eventTypeList != null;
    }

    public KnativeSchemaFluent.EventTypeListNested<A> withNewEventTypeList(){
            return new EventTypeListNestedImpl();
    }

    public KnativeSchemaFluent.EventTypeListNested<A> withNewEventTypeListLike(EventTypeList item){
            return new EventTypeListNestedImpl(item);
    }

    public KnativeSchemaFluent.EventTypeListNested<A> editEventTypeList(){
            return withNewEventTypeListLike(getEventTypeList());
    }

    public KnativeSchemaFluent.EventTypeListNested<A> editOrNewEventTypeList(){
            return withNewEventTypeListLike(getEventTypeList() != null ? getEventTypeList(): new EventTypeListBuilder().build());
    }

    public KnativeSchemaFluent.EventTypeListNested<A> editOrNewEventTypeListLike(EventTypeList item){
            return withNewEventTypeListLike(getEventTypeList() != null ? getEventTypeList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInMemoryChannel instead.
 * @return The buildable object.
 */
@Deprecated public InMemoryChannel getInMemoryChannel(){
            return this.inMemoryChannel!=null?this.inMemoryChannel.build():null;
    }

    public InMemoryChannel buildInMemoryChannel(){
            return this.inMemoryChannel!=null?this.inMemoryChannel.build():null;
    }

    public A withInMemoryChannel(InMemoryChannel inMemoryChannel){
            _visitables.get("inMemoryChannel").remove(this.inMemoryChannel);
            if (inMemoryChannel!=null){ this.inMemoryChannel= new InMemoryChannelBuilder(inMemoryChannel); _visitables.get("inMemoryChannel").add(this.inMemoryChannel);} return (A) this;
    }

    public Boolean hasInMemoryChannel(){
            return this.inMemoryChannel != null;
    }

    public KnativeSchemaFluent.InMemoryChannelNested<A> withNewInMemoryChannel(){
            return new InMemoryChannelNestedImpl();
    }

    public KnativeSchemaFluent.InMemoryChannelNested<A> withNewInMemoryChannelLike(InMemoryChannel item){
            return new InMemoryChannelNestedImpl(item);
    }

    public KnativeSchemaFluent.InMemoryChannelNested<A> editInMemoryChannel(){
            return withNewInMemoryChannelLike(getInMemoryChannel());
    }

    public KnativeSchemaFluent.InMemoryChannelNested<A> editOrNewInMemoryChannel(){
            return withNewInMemoryChannelLike(getInMemoryChannel() != null ? getInMemoryChannel(): new InMemoryChannelBuilder().build());
    }

    public KnativeSchemaFluent.InMemoryChannelNested<A> editOrNewInMemoryChannelLike(InMemoryChannel item){
            return withNewInMemoryChannelLike(getInMemoryChannel() != null ? getInMemoryChannel(): item);
    }

    
/**
 * This method has been deprecated, please use method buildInMemoryChannelList instead.
 * @return The buildable object.
 */
@Deprecated public InMemoryChannelList getInMemoryChannelList(){
            return this.inMemoryChannelList!=null?this.inMemoryChannelList.build():null;
    }

    public InMemoryChannelList buildInMemoryChannelList(){
            return this.inMemoryChannelList!=null?this.inMemoryChannelList.build():null;
    }

    public A withInMemoryChannelList(InMemoryChannelList inMemoryChannelList){
            _visitables.get("inMemoryChannelList").remove(this.inMemoryChannelList);
            if (inMemoryChannelList!=null){ this.inMemoryChannelList= new InMemoryChannelListBuilder(inMemoryChannelList); _visitables.get("inMemoryChannelList").add(this.inMemoryChannelList);} return (A) this;
    }

    public Boolean hasInMemoryChannelList(){
            return this.inMemoryChannelList != null;
    }

    public KnativeSchemaFluent.InMemoryChannelListNested<A> withNewInMemoryChannelList(){
            return new InMemoryChannelListNestedImpl();
    }

    public KnativeSchemaFluent.InMemoryChannelListNested<A> withNewInMemoryChannelListLike(InMemoryChannelList item){
            return new InMemoryChannelListNestedImpl(item);
    }

    public KnativeSchemaFluent.InMemoryChannelListNested<A> editInMemoryChannelList(){
            return withNewInMemoryChannelListLike(getInMemoryChannelList());
    }

    public KnativeSchemaFluent.InMemoryChannelListNested<A> editOrNewInMemoryChannelList(){
            return withNewInMemoryChannelListLike(getInMemoryChannelList() != null ? getInMemoryChannelList(): new InMemoryChannelListBuilder().build());
    }

    public KnativeSchemaFluent.InMemoryChannelListNested<A> editOrNewInMemoryChannelListLike(InMemoryChannelList item){
            return withNewInMemoryChannelListLike(getInMemoryChannelList() != null ? getInMemoryChannelList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRevision instead.
 * @return The buildable object.
 */
@Deprecated public Revision getRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public Revision buildRevision(){
            return this.revision!=null?this.revision.build():null;
    }

    public A withRevision(Revision revision){
            _visitables.get("revision").remove(this.revision);
            if (revision!=null){ this.revision= new RevisionBuilder(revision); _visitables.get("revision").add(this.revision);} return (A) this;
    }

    public Boolean hasRevision(){
            return this.revision != null;
    }

    public KnativeSchemaFluent.RevisionNested<A> withNewRevision(){
            return new RevisionNestedImpl();
    }

    public KnativeSchemaFluent.RevisionNested<A> withNewRevisionLike(Revision item){
            return new RevisionNestedImpl(item);
    }

    public KnativeSchemaFluent.RevisionNested<A> editRevision(){
            return withNewRevisionLike(getRevision());
    }

    public KnativeSchemaFluent.RevisionNested<A> editOrNewRevision(){
            return withNewRevisionLike(getRevision() != null ? getRevision(): new RevisionBuilder().build());
    }

    public KnativeSchemaFluent.RevisionNested<A> editOrNewRevisionLike(Revision item){
            return withNewRevisionLike(getRevision() != null ? getRevision(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRevisionList instead.
 * @return The buildable object.
 */
@Deprecated public RevisionList getRevisionList(){
            return this.revisionList!=null?this.revisionList.build():null;
    }

    public RevisionList buildRevisionList(){
            return this.revisionList!=null?this.revisionList.build():null;
    }

    public A withRevisionList(RevisionList revisionList){
            _visitables.get("revisionList").remove(this.revisionList);
            if (revisionList!=null){ this.revisionList= new RevisionListBuilder(revisionList); _visitables.get("revisionList").add(this.revisionList);} return (A) this;
    }

    public Boolean hasRevisionList(){
            return this.revisionList != null;
    }

    public KnativeSchemaFluent.RevisionListNested<A> withNewRevisionList(){
            return new RevisionListNestedImpl();
    }

    public KnativeSchemaFluent.RevisionListNested<A> withNewRevisionListLike(RevisionList item){
            return new RevisionListNestedImpl(item);
    }

    public KnativeSchemaFluent.RevisionListNested<A> editRevisionList(){
            return withNewRevisionListLike(getRevisionList());
    }

    public KnativeSchemaFluent.RevisionListNested<A> editOrNewRevisionList(){
            return withNewRevisionListLike(getRevisionList() != null ? getRevisionList(): new RevisionListBuilder().build());
    }

    public KnativeSchemaFluent.RevisionListNested<A> editOrNewRevisionListLike(RevisionList item){
            return withNewRevisionListLike(getRevisionList() != null ? getRevisionList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public Route getRoute(){
            return this.route!=null?this.route.build():null;
    }

    public Route buildRoute(){
            return this.route!=null?this.route.build():null;
    }

    public A withRoute(Route route){
            _visitables.get("route").remove(this.route);
            if (route!=null){ this.route= new RouteBuilder(route); _visitables.get("route").add(this.route);} return (A) this;
    }

    public Boolean hasRoute(){
            return this.route != null;
    }

    public KnativeSchemaFluent.RouteNested<A> withNewRoute(){
            return new RouteNestedImpl();
    }

    public KnativeSchemaFluent.RouteNested<A> withNewRouteLike(Route item){
            return new RouteNestedImpl(item);
    }

    public KnativeSchemaFluent.RouteNested<A> editRoute(){
            return withNewRouteLike(getRoute());
    }

    public KnativeSchemaFluent.RouteNested<A> editOrNewRoute(){
            return withNewRouteLike(getRoute() != null ? getRoute(): new RouteBuilder().build());
    }

    public KnativeSchemaFluent.RouteNested<A> editOrNewRouteLike(Route item){
            return withNewRouteLike(getRoute() != null ? getRoute(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRouteList instead.
 * @return The buildable object.
 */
@Deprecated public RouteList getRouteList(){
            return this.routeList!=null?this.routeList.build():null;
    }

    public RouteList buildRouteList(){
            return this.routeList!=null?this.routeList.build():null;
    }

    public A withRouteList(RouteList routeList){
            _visitables.get("routeList").remove(this.routeList);
            if (routeList!=null){ this.routeList= new RouteListBuilder(routeList); _visitables.get("routeList").add(this.routeList);} return (A) this;
    }

    public Boolean hasRouteList(){
            return this.routeList != null;
    }

    public KnativeSchemaFluent.RouteListNested<A> withNewRouteList(){
            return new RouteListNestedImpl();
    }

    public KnativeSchemaFluent.RouteListNested<A> withNewRouteListLike(RouteList item){
            return new RouteListNestedImpl(item);
    }

    public KnativeSchemaFluent.RouteListNested<A> editRouteList(){
            return withNewRouteListLike(getRouteList());
    }

    public KnativeSchemaFluent.RouteListNested<A> editOrNewRouteList(){
            return withNewRouteListLike(getRouteList() != null ? getRouteList(): new RouteListBuilder().build());
    }

    public KnativeSchemaFluent.RouteListNested<A> editOrNewRouteListLike(RouteList item){
            return withNewRouteListLike(getRouteList() != null ? getRouteList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSequence instead.
 * @return The buildable object.
 */
@Deprecated public Sequence getSequence(){
            return this.sequence!=null?this.sequence.build():null;
    }

    public Sequence buildSequence(){
            return this.sequence!=null?this.sequence.build():null;
    }

    public A withSequence(Sequence sequence){
            _visitables.get("sequence").remove(this.sequence);
            if (sequence!=null){ this.sequence= new SequenceBuilder(sequence); _visitables.get("sequence").add(this.sequence);} return (A) this;
    }

    public Boolean hasSequence(){
            return this.sequence != null;
    }

    public KnativeSchemaFluent.SequenceNested<A> withNewSequence(){
            return new SequenceNestedImpl();
    }

    public KnativeSchemaFluent.SequenceNested<A> withNewSequenceLike(Sequence item){
            return new SequenceNestedImpl(item);
    }

    public KnativeSchemaFluent.SequenceNested<A> editSequence(){
            return withNewSequenceLike(getSequence());
    }

    public KnativeSchemaFluent.SequenceNested<A> editOrNewSequence(){
            return withNewSequenceLike(getSequence() != null ? getSequence(): new SequenceBuilder().build());
    }

    public KnativeSchemaFluent.SequenceNested<A> editOrNewSequenceLike(Sequence item){
            return withNewSequenceLike(getSequence() != null ? getSequence(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSequenceList instead.
 * @return The buildable object.
 */
@Deprecated public SequenceList getSequenceList(){
            return this.sequenceList!=null?this.sequenceList.build():null;
    }

    public SequenceList buildSequenceList(){
            return this.sequenceList!=null?this.sequenceList.build():null;
    }

    public A withSequenceList(SequenceList sequenceList){
            _visitables.get("sequenceList").remove(this.sequenceList);
            if (sequenceList!=null){ this.sequenceList= new SequenceListBuilder(sequenceList); _visitables.get("sequenceList").add(this.sequenceList);} return (A) this;
    }

    public Boolean hasSequenceList(){
            return this.sequenceList != null;
    }

    public KnativeSchemaFluent.SequenceListNested<A> withNewSequenceList(){
            return new SequenceListNestedImpl();
    }

    public KnativeSchemaFluent.SequenceListNested<A> withNewSequenceListLike(SequenceList item){
            return new SequenceListNestedImpl(item);
    }

    public KnativeSchemaFluent.SequenceListNested<A> editSequenceList(){
            return withNewSequenceListLike(getSequenceList());
    }

    public KnativeSchemaFluent.SequenceListNested<A> editOrNewSequenceList(){
            return withNewSequenceListLike(getSequenceList() != null ? getSequenceList(): new SequenceListBuilder().build());
    }

    public KnativeSchemaFluent.SequenceListNested<A> editOrNewSequenceListLike(SequenceList item){
            return withNewSequenceListLike(getSequenceList() != null ? getSequenceList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public Service getService(){
            return this.service!=null?this.service.build():null;
    }

    public Service buildService(){
            return this.service!=null?this.service.build():null;
    }

    public A withService(Service service){
            _visitables.get("service").remove(this.service);
            if (service!=null){ this.service= new ServiceBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public Boolean hasService(){
            return this.service != null;
    }

    public KnativeSchemaFluent.ServiceNested<A> withNewService(){
            return new ServiceNestedImpl();
    }

    public KnativeSchemaFluent.ServiceNested<A> withNewServiceLike(Service item){
            return new ServiceNestedImpl(item);
    }

    public KnativeSchemaFluent.ServiceNested<A> editService(){
            return withNewServiceLike(getService());
    }

    public KnativeSchemaFluent.ServiceNested<A> editOrNewService(){
            return withNewServiceLike(getService() != null ? getService(): new ServiceBuilder().build());
    }

    public KnativeSchemaFluent.ServiceNested<A> editOrNewServiceLike(Service item){
            return withNewServiceLike(getService() != null ? getService(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceList instead.
 * @return The buildable object.
 */
@Deprecated public ServiceList getServiceList(){
            return this.serviceList!=null?this.serviceList.build():null;
    }

    public ServiceList buildServiceList(){
            return this.serviceList!=null?this.serviceList.build():null;
    }

    public A withServiceList(ServiceList serviceList){
            _visitables.get("serviceList").remove(this.serviceList);
            if (serviceList!=null){ this.serviceList= new ServiceListBuilder(serviceList); _visitables.get("serviceList").add(this.serviceList);} return (A) this;
    }

    public Boolean hasServiceList(){
            return this.serviceList != null;
    }

    public KnativeSchemaFluent.ServiceListNested<A> withNewServiceList(){
            return new ServiceListNestedImpl();
    }

    public KnativeSchemaFluent.ServiceListNested<A> withNewServiceListLike(ServiceList item){
            return new ServiceListNestedImpl(item);
    }

    public KnativeSchemaFluent.ServiceListNested<A> editServiceList(){
            return withNewServiceListLike(getServiceList());
    }

    public KnativeSchemaFluent.ServiceListNested<A> editOrNewServiceList(){
            return withNewServiceListLike(getServiceList() != null ? getServiceList(): new ServiceListBuilder().build());
    }

    public KnativeSchemaFluent.ServiceListNested<A> editOrNewServiceListLike(ServiceList item){
            return withNewServiceListLike(getServiceList() != null ? getServiceList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscription instead.
 * @return The buildable object.
 */
@Deprecated public Subscription getSubscription(){
            return this.subscription!=null?this.subscription.build():null;
    }

    public Subscription buildSubscription(){
            return this.subscription!=null?this.subscription.build():null;
    }

    public A withSubscription(Subscription subscription){
            _visitables.get("subscription").remove(this.subscription);
            if (subscription!=null){ this.subscription= new SubscriptionBuilder(subscription); _visitables.get("subscription").add(this.subscription);} return (A) this;
    }

    public Boolean hasSubscription(){
            return this.subscription != null;
    }

    public KnativeSchemaFluent.SubscriptionNested<A> withNewSubscription(){
            return new SubscriptionNestedImpl();
    }

    public KnativeSchemaFluent.SubscriptionNested<A> withNewSubscriptionLike(Subscription item){
            return new SubscriptionNestedImpl(item);
    }

    public KnativeSchemaFluent.SubscriptionNested<A> editSubscription(){
            return withNewSubscriptionLike(getSubscription());
    }

    public KnativeSchemaFluent.SubscriptionNested<A> editOrNewSubscription(){
            return withNewSubscriptionLike(getSubscription() != null ? getSubscription(): new SubscriptionBuilder().build());
    }

    public KnativeSchemaFluent.SubscriptionNested<A> editOrNewSubscriptionLike(Subscription item){
            return withNewSubscriptionLike(getSubscription() != null ? getSubscription(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscriptionList instead.
 * @return The buildable object.
 */
@Deprecated public SubscriptionList getSubscriptionList(){
            return this.subscriptionList!=null?this.subscriptionList.build():null;
    }

    public SubscriptionList buildSubscriptionList(){
            return this.subscriptionList!=null?this.subscriptionList.build():null;
    }

    public A withSubscriptionList(SubscriptionList subscriptionList){
            _visitables.get("subscriptionList").remove(this.subscriptionList);
            if (subscriptionList!=null){ this.subscriptionList= new SubscriptionListBuilder(subscriptionList); _visitables.get("subscriptionList").add(this.subscriptionList);} return (A) this;
    }

    public Boolean hasSubscriptionList(){
            return this.subscriptionList != null;
    }

    public KnativeSchemaFluent.SubscriptionListNested<A> withNewSubscriptionList(){
            return new SubscriptionListNestedImpl();
    }

    public KnativeSchemaFluent.SubscriptionListNested<A> withNewSubscriptionListLike(SubscriptionList item){
            return new SubscriptionListNestedImpl(item);
    }

    public KnativeSchemaFluent.SubscriptionListNested<A> editSubscriptionList(){
            return withNewSubscriptionListLike(getSubscriptionList());
    }

    public KnativeSchemaFluent.SubscriptionListNested<A> editOrNewSubscriptionList(){
            return withNewSubscriptionListLike(getSubscriptionList() != null ? getSubscriptionList(): new SubscriptionListBuilder().build());
    }

    public KnativeSchemaFluent.SubscriptionListNested<A> editOrNewSubscriptionListLike(SubscriptionList item){
            return withNewSubscriptionListLike(getSubscriptionList() != null ? getSubscriptionList(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTrigger instead.
 * @return The buildable object.
 */
@Deprecated public Trigger getTrigger(){
            return this.trigger!=null?this.trigger.build():null;
    }

    public Trigger buildTrigger(){
            return this.trigger!=null?this.trigger.build():null;
    }

    public A withTrigger(Trigger trigger){
            _visitables.get("trigger").remove(this.trigger);
            if (trigger!=null){ this.trigger= new TriggerBuilder(trigger); _visitables.get("trigger").add(this.trigger);} return (A) this;
    }

    public Boolean hasTrigger(){
            return this.trigger != null;
    }

    public KnativeSchemaFluent.TriggerNested<A> withNewTrigger(){
            return new TriggerNestedImpl();
    }

    public KnativeSchemaFluent.TriggerNested<A> withNewTriggerLike(Trigger item){
            return new TriggerNestedImpl(item);
    }

    public KnativeSchemaFluent.TriggerNested<A> editTrigger(){
            return withNewTriggerLike(getTrigger());
    }

    public KnativeSchemaFluent.TriggerNested<A> editOrNewTrigger(){
            return withNewTriggerLike(getTrigger() != null ? getTrigger(): new TriggerBuilder().build());
    }

    public KnativeSchemaFluent.TriggerNested<A> editOrNewTriggerLike(Trigger item){
            return withNewTriggerLike(getTrigger() != null ? getTrigger(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTriggerList instead.
 * @return The buildable object.
 */
@Deprecated public TriggerList getTriggerList(){
            return this.triggerList!=null?this.triggerList.build():null;
    }

    public TriggerList buildTriggerList(){
            return this.triggerList!=null?this.triggerList.build():null;
    }

    public A withTriggerList(TriggerList triggerList){
            _visitables.get("triggerList").remove(this.triggerList);
            if (triggerList!=null){ this.triggerList= new TriggerListBuilder(triggerList); _visitables.get("triggerList").add(this.triggerList);} return (A) this;
    }

    public Boolean hasTriggerList(){
            return this.triggerList != null;
    }

    public KnativeSchemaFluent.TriggerListNested<A> withNewTriggerList(){
            return new TriggerListNestedImpl();
    }

    public KnativeSchemaFluent.TriggerListNested<A> withNewTriggerListLike(TriggerList item){
            return new TriggerListNestedImpl(item);
    }

    public KnativeSchemaFluent.TriggerListNested<A> editTriggerList(){
            return withNewTriggerListLike(getTriggerList());
    }

    public KnativeSchemaFluent.TriggerListNested<A> editOrNewTriggerList(){
            return withNewTriggerListLike(getTriggerList() != null ? getTriggerList(): new TriggerListBuilder().build());
    }

    public KnativeSchemaFluent.TriggerListNested<A> editOrNewTriggerListLike(TriggerList item){
            return withNewTriggerListLike(getTriggerList() != null ? getTriggerList(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KnativeSchemaFluentImpl that = (KnativeSchemaFluentImpl) o;
            if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
            if (brokerList != null ? !brokerList.equals(that.brokerList) :that.brokerList != null) return false;
            if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
            if (channelList != null ? !channelList.equals(that.channelList) :that.channelList != null) return false;
            if (clusterChannelProvisioner != null ? !clusterChannelProvisioner.equals(that.clusterChannelProvisioner) :that.clusterChannelProvisioner != null) return false;
            if (clusterChannelProvisionerList != null ? !clusterChannelProvisionerList.equals(that.clusterChannelProvisionerList) :that.clusterChannelProvisionerList != null) return false;
            if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
            if (configurationList != null ? !configurationList.equals(that.configurationList) :that.configurationList != null) return false;
            if (eventType != null ? !eventType.equals(that.eventType) :that.eventType != null) return false;
            if (eventTypeList != null ? !eventTypeList.equals(that.eventTypeList) :that.eventTypeList != null) return false;
            if (inMemoryChannel != null ? !inMemoryChannel.equals(that.inMemoryChannel) :that.inMemoryChannel != null) return false;
            if (inMemoryChannelList != null ? !inMemoryChannelList.equals(that.inMemoryChannelList) :that.inMemoryChannelList != null) return false;
            if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
            if (revisionList != null ? !revisionList.equals(that.revisionList) :that.revisionList != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            if (routeList != null ? !routeList.equals(that.routeList) :that.routeList != null) return false;
            if (sequence != null ? !sequence.equals(that.sequence) :that.sequence != null) return false;
            if (sequenceList != null ? !sequenceList.equals(that.sequenceList) :that.sequenceList != null) return false;
            if (service != null ? !service.equals(that.service) :that.service != null) return false;
            if (serviceList != null ? !serviceList.equals(that.serviceList) :that.serviceList != null) return false;
            if (subscription != null ? !subscription.equals(that.subscription) :that.subscription != null) return false;
            if (subscriptionList != null ? !subscriptionList.equals(that.subscriptionList) :that.subscriptionList != null) return false;
            if (trigger != null ? !trigger.equals(that.trigger) :that.trigger != null) return false;
            if (triggerList != null ? !triggerList.equals(that.triggerList) :that.triggerList != null) return false;
            return true;
    }


    public class BrokerNestedImpl<N> extends BrokerFluentImpl<KnativeSchemaFluent.BrokerNested<N>> implements KnativeSchemaFluent.BrokerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BrokerBuilder builder;
    
            BrokerNestedImpl(Broker item){
                    this.builder = new BrokerBuilder(this, item);
            }
            BrokerNestedImpl(){
                    this.builder = new BrokerBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withBroker(builder.build());
    }
    public N endBroker(){
            return and();
    }

}
    public class BrokerListNestedImpl<N> extends BrokerListFluentImpl<KnativeSchemaFluent.BrokerListNested<N>> implements KnativeSchemaFluent.BrokerListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BrokerListBuilder builder;
    
            BrokerListNestedImpl(BrokerList item){
                    this.builder = new BrokerListBuilder(this, item);
            }
            BrokerListNestedImpl(){
                    this.builder = new BrokerListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withBrokerList(builder.build());
    }
    public N endBrokerList(){
            return and();
    }

}
    public class ChannelNestedImpl<N> extends ChannelFluentImpl<KnativeSchemaFluent.ChannelNested<N>> implements KnativeSchemaFluent.ChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelBuilder builder;
    
            ChannelNestedImpl(Channel item){
                    this.builder = new ChannelBuilder(this, item);
            }
            ChannelNestedImpl(){
                    this.builder = new ChannelBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withChannel(builder.build());
    }
    public N endChannel(){
            return and();
    }

}
    public class ChannelListNestedImpl<N> extends ChannelListFluentImpl<KnativeSchemaFluent.ChannelListNested<N>> implements KnativeSchemaFluent.ChannelListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelListBuilder builder;
    
            ChannelListNestedImpl(ChannelList item){
                    this.builder = new ChannelListBuilder(this, item);
            }
            ChannelListNestedImpl(){
                    this.builder = new ChannelListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withChannelList(builder.build());
    }
    public N endChannelList(){
            return and();
    }

}
    public class ClusterChannelProvisionerNestedImpl<N> extends ClusterChannelProvisionerFluentImpl<KnativeSchemaFluent.ClusterChannelProvisionerNested<N>> implements KnativeSchemaFluent.ClusterChannelProvisionerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterChannelProvisionerBuilder builder;
    
            ClusterChannelProvisionerNestedImpl(ClusterChannelProvisioner item){
                    this.builder = new ClusterChannelProvisionerBuilder(this, item);
            }
            ClusterChannelProvisionerNestedImpl(){
                    this.builder = new ClusterChannelProvisionerBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withClusterChannelProvisioner(builder.build());
    }
    public N endClusterChannelProvisioner(){
            return and();
    }

}
    public class ClusterChannelProvisionerListNestedImpl<N> extends ClusterChannelProvisionerListFluentImpl<KnativeSchemaFluent.ClusterChannelProvisionerListNested<N>> implements KnativeSchemaFluent.ClusterChannelProvisionerListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterChannelProvisionerListBuilder builder;
    
            ClusterChannelProvisionerListNestedImpl(ClusterChannelProvisionerList item){
                    this.builder = new ClusterChannelProvisionerListBuilder(this, item);
            }
            ClusterChannelProvisionerListNestedImpl(){
                    this.builder = new ClusterChannelProvisionerListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withClusterChannelProvisionerList(builder.build());
    }
    public N endClusterChannelProvisionerList(){
            return and();
    }

}
    public class ConfigurationNestedImpl<N> extends ConfigurationFluentImpl<KnativeSchemaFluent.ConfigurationNested<N>> implements KnativeSchemaFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigurationBuilder builder;
    
            ConfigurationNestedImpl(Configuration item){
                    this.builder = new ConfigurationBuilder(this, item);
            }
            ConfigurationNestedImpl(){
                    this.builder = new ConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration(){
            return and();
    }

}
    public class ConfigurationListNestedImpl<N> extends ConfigurationListFluentImpl<KnativeSchemaFluent.ConfigurationListNested<N>> implements KnativeSchemaFluent.ConfigurationListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigurationListBuilder builder;
    
            ConfigurationListNestedImpl(ConfigurationList item){
                    this.builder = new ConfigurationListBuilder(this, item);
            }
            ConfigurationListNestedImpl(){
                    this.builder = new ConfigurationListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withConfigurationList(builder.build());
    }
    public N endConfigurationList(){
            return and();
    }

}
    public class EventTypeNestedImpl<N> extends EventTypeFluentImpl<KnativeSchemaFluent.EventTypeNested<N>> implements KnativeSchemaFluent.EventTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventTypeBuilder builder;
    
            EventTypeNestedImpl(EventType item){
                    this.builder = new EventTypeBuilder(this, item);
            }
            EventTypeNestedImpl(){
                    this.builder = new EventTypeBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withEventType(builder.build());
    }
    public N endEventType(){
            return and();
    }

}
    public class EventTypeListNestedImpl<N> extends EventTypeListFluentImpl<KnativeSchemaFluent.EventTypeListNested<N>> implements KnativeSchemaFluent.EventTypeListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventTypeListBuilder builder;
    
            EventTypeListNestedImpl(EventTypeList item){
                    this.builder = new EventTypeListBuilder(this, item);
            }
            EventTypeListNestedImpl(){
                    this.builder = new EventTypeListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withEventTypeList(builder.build());
    }
    public N endEventTypeList(){
            return and();
    }

}
    public class InMemoryChannelNestedImpl<N> extends InMemoryChannelFluentImpl<KnativeSchemaFluent.InMemoryChannelNested<N>> implements KnativeSchemaFluent.InMemoryChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InMemoryChannelBuilder builder;
    
            InMemoryChannelNestedImpl(InMemoryChannel item){
                    this.builder = new InMemoryChannelBuilder(this, item);
            }
            InMemoryChannelNestedImpl(){
                    this.builder = new InMemoryChannelBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withInMemoryChannel(builder.build());
    }
    public N endInMemoryChannel(){
            return and();
    }

}
    public class InMemoryChannelListNestedImpl<N> extends InMemoryChannelListFluentImpl<KnativeSchemaFluent.InMemoryChannelListNested<N>> implements KnativeSchemaFluent.InMemoryChannelListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InMemoryChannelListBuilder builder;
    
            InMemoryChannelListNestedImpl(InMemoryChannelList item){
                    this.builder = new InMemoryChannelListBuilder(this, item);
            }
            InMemoryChannelListNestedImpl(){
                    this.builder = new InMemoryChannelListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withInMemoryChannelList(builder.build());
    }
    public N endInMemoryChannelList(){
            return and();
    }

}
    public class RevisionNestedImpl<N> extends RevisionFluentImpl<KnativeSchemaFluent.RevisionNested<N>> implements KnativeSchemaFluent.RevisionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RevisionBuilder builder;
    
            RevisionNestedImpl(Revision item){
                    this.builder = new RevisionBuilder(this, item);
            }
            RevisionNestedImpl(){
                    this.builder = new RevisionBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withRevision(builder.build());
    }
    public N endRevision(){
            return and();
    }

}
    public class RevisionListNestedImpl<N> extends RevisionListFluentImpl<KnativeSchemaFluent.RevisionListNested<N>> implements KnativeSchemaFluent.RevisionListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RevisionListBuilder builder;
    
            RevisionListNestedImpl(RevisionList item){
                    this.builder = new RevisionListBuilder(this, item);
            }
            RevisionListNestedImpl(){
                    this.builder = new RevisionListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withRevisionList(builder.build());
    }
    public N endRevisionList(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends RouteFluentImpl<KnativeSchemaFluent.RouteNested<N>> implements KnativeSchemaFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
    
            RouteNestedImpl(Route item){
                    this.builder = new RouteBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withRoute(builder.build());
    }
    public N endRoute(){
            return and();
    }

}
    public class RouteListNestedImpl<N> extends RouteListFluentImpl<KnativeSchemaFluent.RouteListNested<N>> implements KnativeSchemaFluent.RouteListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteListBuilder builder;
    
            RouteListNestedImpl(RouteList item){
                    this.builder = new RouteListBuilder(this, item);
            }
            RouteListNestedImpl(){
                    this.builder = new RouteListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withRouteList(builder.build());
    }
    public N endRouteList(){
            return and();
    }

}
    public class SequenceNestedImpl<N> extends SequenceFluentImpl<KnativeSchemaFluent.SequenceNested<N>> implements KnativeSchemaFluent.SequenceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceBuilder builder;
    
            SequenceNestedImpl(Sequence item){
                    this.builder = new SequenceBuilder(this, item);
            }
            SequenceNestedImpl(){
                    this.builder = new SequenceBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withSequence(builder.build());
    }
    public N endSequence(){
            return and();
    }

}
    public class SequenceListNestedImpl<N> extends SequenceListFluentImpl<KnativeSchemaFluent.SequenceListNested<N>> implements KnativeSchemaFluent.SequenceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceListBuilder builder;
    
            SequenceListNestedImpl(SequenceList item){
                    this.builder = new SequenceListBuilder(this, item);
            }
            SequenceListNestedImpl(){
                    this.builder = new SequenceListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withSequenceList(builder.build());
    }
    public N endSequenceList(){
            return and();
    }

}
    public class ServiceNestedImpl<N> extends ServiceFluentImpl<KnativeSchemaFluent.ServiceNested<N>> implements KnativeSchemaFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceBuilder builder;
    
            ServiceNestedImpl(Service item){
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceNestedImpl(){
                    this.builder = new ServiceBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withService(builder.build());
    }
    public N endService(){
            return and();
    }

}
    public class ServiceListNestedImpl<N> extends ServiceListFluentImpl<KnativeSchemaFluent.ServiceListNested<N>> implements KnativeSchemaFluent.ServiceListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceListBuilder builder;
    
            ServiceListNestedImpl(ServiceList item){
                    this.builder = new ServiceListBuilder(this, item);
            }
            ServiceListNestedImpl(){
                    this.builder = new ServiceListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withServiceList(builder.build());
    }
    public N endServiceList(){
            return and();
    }

}
    public class SubscriptionNestedImpl<N> extends SubscriptionFluentImpl<KnativeSchemaFluent.SubscriptionNested<N>> implements KnativeSchemaFluent.SubscriptionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriptionBuilder builder;
    
            SubscriptionNestedImpl(Subscription item){
                    this.builder = new SubscriptionBuilder(this, item);
            }
            SubscriptionNestedImpl(){
                    this.builder = new SubscriptionBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withSubscription(builder.build());
    }
    public N endSubscription(){
            return and();
    }

}
    public class SubscriptionListNestedImpl<N> extends SubscriptionListFluentImpl<KnativeSchemaFluent.SubscriptionListNested<N>> implements KnativeSchemaFluent.SubscriptionListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriptionListBuilder builder;
    
            SubscriptionListNestedImpl(SubscriptionList item){
                    this.builder = new SubscriptionListBuilder(this, item);
            }
            SubscriptionListNestedImpl(){
                    this.builder = new SubscriptionListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withSubscriptionList(builder.build());
    }
    public N endSubscriptionList(){
            return and();
    }

}
    public class TriggerNestedImpl<N> extends TriggerFluentImpl<KnativeSchemaFluent.TriggerNested<N>> implements KnativeSchemaFluent.TriggerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerBuilder builder;
    
            TriggerNestedImpl(Trigger item){
                    this.builder = new TriggerBuilder(this, item);
            }
            TriggerNestedImpl(){
                    this.builder = new TriggerBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withTrigger(builder.build());
    }
    public N endTrigger(){
            return and();
    }

}
    public class TriggerListNestedImpl<N> extends TriggerListFluentImpl<KnativeSchemaFluent.TriggerListNested<N>> implements KnativeSchemaFluent.TriggerListNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerListBuilder builder;
    
            TriggerListNestedImpl(TriggerList item){
                    this.builder = new TriggerListBuilder(this, item);
            }
            TriggerListNestedImpl(){
                    this.builder = new TriggerListBuilder(this);
            }
    
    public N and(){
            return (N) KnativeSchemaFluentImpl.this.withTriggerList(builder.build());
    }
    public N endTriggerList(){
            return and();
    }

}


}
